pro read_sweep_b, bavg, timetags, nif=nif, ele=ele, ion=ion, $
                  time_interval=t
;
;   Return sweep resolution averaged B.
;
;   Input:
;          /ele for electrons
;          /ion for ions
;          /nif for nif coordinates - REQUIRED
;          time_interval: [tstart, tend]
;
;   Output:
;          bavg: B
;          timetags: corresponding timetags
;
;
restore, '/home/jbf/the_paper/march/temp_aniso.idlsav'

if not keyword_set(nif) then message, '/nif required for sweep-resolution B'

if keyword_set(ele) then begin
    timetags=ele_ttags
    bavg=b_nif_ele
endif else if keyword_set(ion) then begin
    timetags=ion_ttags
    bavg=b_nif_ion
endif else message, 'Require either /ele or /ion.'

if keyword_set(t) then begin
    hyd_data, timetags, 'time_bin_start_ssm', tstart
    hyd_data, timetags, 'time_bin_width_seconds', twidth

    print, tstart(0), tstart(n_elements(tstart)-1)+twidth(n_elements(twidth)-1)

    r=where(tstart ge t(0) and tstart+twidth le t(1))
    if r(0) ne -1 then begin
        timetags=timetags(r)
        bavg=bavg(r,*)
    endif else message, 'ERROR: time range empty.'
endif

return
end
