pro read_tmp_bdata, time, bx, by, bz, filename, nbuffer=nbuffer
;
;   Read in Tempory B Data in simple formatted form and return arrays.
;
;
;   Input Parameters: time, bx, by, bz: physical values
;                     filename:         name of data file
;                     nbuffer:          length of buffer to use
;
;
spawn, 'date'

get_lun, unit
openr, unit, filename

time=dblarr(1)
bx=fltarr(1)
by=fltarr(1)
bz=fltarr(1)

t0=double(0.0)
bx0=float(0)
by0=float(0)
bz0=float(0)

if not keyword_set(nbuffer) then nbuffer=1000
if nbuffer lt 1 then nbuffer=1

t1=dblarr(nbuffer)
bx1=fltarr(nbuffer)
by1=fltarr(nbuffer)
bz1=fltarr(nbuffer)
i=long(-1)
while not eof(unit) do begin
    readf, unit, t0, bx0, by0, bz0
    i=i+1
    t1(i)=t0
    bx1(i)=bx0
    by1(i)=by0
    bz1(i)=bz0
    if (i eq nbuffer-1) then begin
        time=[time,t1]
        bx=[bx,bx1]
        by=[by,by1]
        bz=[bz,bz1]
        i=-1
    endif
endwhile
n=long(n_elements(bx))
if i ge 0 then begin
    time=[time(1:n-1),t1(0:i-1)]
    bx=[bx(1:n-1),bx1(0:i-1)]
    by=[by(1:n-1),by1(0:i-1)]
    bz=[bz(1:n-1),bz1(0:i-1)]
endif else begin
    time=time(1:n-1)
    bx=bx(1:n-1)
    by=by(1:n-1)
    bz=bz(1:n-1)
endelse
close, unit
free_lun, unit

spawn, 'date'

return
end
