PRO read_validb_56, date_in, validb, time_validb, file, $
                    time_interval=t_i, stop=stop, verbose=verbose, out=out, $
                    dd=dd
;
;   Extract the validb flags for a time period (NOW THE WHOLE DAY ONLY!)
;
   IF NOT keyword_set(t_i) THEN t_i = [0.0, 86400.0]
;
;  Determine filename
;
   IF (file EQ '') THEN BEGIN 
      date = strtrim(date_in,2)
      IF keyword_set(dd) THEN file = hydra_findfile(date,/level1) $
      ELSE file = hydra_findfile(date,/ddcal)
      IF (file EQ '') THEN BEGIN
         print, 'DDCAL file not found for '+date+'.'
         validb = -1
         time = -1
         return
      ENDIF
   ENDIF ELSE BEGIN
      print, 'Reading from '+file
   ENDELSE 
;
;  Open file and read block quantities
;
   id = cdf_open(file)
   cdf_control, id, variable='BLOCK_MODE', get_var_info=bmi
   max_block = bmi.maxrec+1
   cdf_varget, id, 'BLOCK_MODE', block_mode, rec_count=max_block
   cdf_varget, id, 'BLOCK_INDEX', block_index, rec_count=max_block
   block_index = block_index-1
   cdf_varget, id, 'BLOCK_TIME', block_time, rec_count=max_block

   time = dblarr(max_block)
   FOR i=0,max_block-1 DO BEGIN 
      cdf_epoch, block_time(i), y, m, d, h, m, s, milli, /breakdown_epoch
      time(i) = (h*60.d0+m)*60.d0+s+0.001d0*milli
   ENDFOR

   validb = bytarr(96,max_block)

   cdf_varget, id, 'BLOCK_STATUS', block_status, rec_count=max_block
   s = where(block_status AND 2)
   ns = n_elements(s)
   FOR i=0,ns-1 DO BEGIN
      IF (i EQ ns-1) THEN smax = max_block-1 ELSE smax = s(i+1)
      smin = s(i)
      cdf_varget, id, 'NAME_SUFFIX', name, rec_start=smin
      name = 'VALIDB'+string(name)

      cdf_varget, id, name, valid, rec_start=0, rec_count=smax-smin+1
      validb(*,smin:smax) = valid      

      IF keyword_set(verbose) THEN BEGIN 
         print, smin, smax, time(smin), time(smax), ' ', name
      ENDIF 
   ENDFOR 

   cdf_close, id

   out = validb

   rmin = where(time GE t_i(0)-13.8 AND time LE t_i(1), rn)
   IF rmin(0) EQ -1 THEN BEGIN
      print, 'No records found for specified time:'+ t_i
      stop
   ENDIF 
   rmax = rmin(rn-1)
   rmin = rmin(0)

   IF keyword_set(verbose) THEN BEGIN 
      print, rmin, rmax, rn
      print, 'Time: ', t_i
      print, 'Time: ', time(rmin:rmax)
      print, 'Validb: ', validb(*,rmin:rmax)
   ENDIF 

   valid = bytarr(8,96,rn)
   c = byte(2^indgen(8))
   FOR i=0,7 DO BEGIN
      valid(i,*,*) = (validb(*,rmin:rmax) AND c(i)) EQ c(i)
   ENDFOR 
   np = 8*96*rn
   validb = reform(valid, np)

   time_validb = dblarr(np)
   hpm = (13.8/768.d0)
   tb = findgen(768)*hpm
   FOR i=long(0),rn-1 DO BEGIN
      ib1 = 768*i
      ib2 = 768*(i+1)-1
      time_validb(ib1:ib2) = tb+time(i+rmin)
   ENDFOR 

   IF keyword_set(stop) THEN stop
   return
END
