PRO read_validb_8, date_in, validb, time_validb, file, $
                    time_interval=t_i, stop=stop, verbose=verbose, out=out, $
                   dd=dd
;
;   Extract the validb flags for a time period
;
   IF NOT keyword_set(t_i) THEN t_i = [0.0, 86400.0]
;
;  Determine filename
;
   IF (file EQ '') THEN BEGIN 
      date = strtrim(date_in,2)
      IF keyword_set(dd) THEN file = hydra_findfile(date,/level1) $
      ELSE file = hydra_findfile(date,/ddcal)
      IF (file EQ '') THEN BEGIN
         print, 'DDCAL file not found for '+date+'.'
         validb = -1
         time = -1
         return
      ENDIF
   ENDIF ELSE BEGIN
      print, 'Reading from '+file
   ENDELSE 
;
;  Open file and MFE mjf quantities
;
   id = cdf_open(file)
   cdf_control, id, variable='B_HIGH_TIME', get_var_info=bmi
   max_mjf = bmi.maxrec
   cdf_varget, id, 'B_HIGH_TIME', time_mjf, rec_count=max_mjf
   cdf_varget, id, 'B_HIGH_DT', dt, rec_count=max_mjf
   cdf_varget, id, 'B_HIGH_VALID', validb, rec_count=max_mjf

   cdf_close, id

   out = validb

   rmin = where(time_mjf GE t_i(0)-9.2 AND time_mjf LE t_i(1), rn)
   IF rmin(0) EQ -1 THEN BEGIN
      print, 'No records found for specified time:'+ t_i
      stop
   ENDIF 
   rmax = rmin(rn-1)
   rmin = rmin(0)

   IF keyword_set(verbose) THEN BEGIN 
      print, rmin, rmax, rn
      print, 'Time: ', t_i
      print, 'Time: ', time_mjf(rmin:rmax)
      print, 'Validb: ', validb(*,rmin:rmax)
   ENDIF 

   valid = bytarr(8,11,rn)
   c = byte(2^indgen(8))
   FOR i=0,7 DO BEGIN
      valid(i,*,*) = (validb(*,rmin:rmax) AND c(i)) EQ c(i)
   ENDFOR 
   np = 8*11*rn
   validb = reform(valid, np)

   time_validb = dblarr(np)
   tb = findgen(88)
   FOR i=long(0),rn-1 DO BEGIN
      ib1 = 88*i
      ib2 = 88*(i+1)-1
      time_validb(ib1:ib2) = time_mjf(i+rmin)+dt(i+rmin)*tb
   ENDFOR 

   IF keyword_set(stop) THEN stop
   return
END
