pro ring, chisq, imin,jmin, i0, it, j0, jt, level, i_interior, j_interior,nmax
;
; Purpose surface chisq(it+1, jt+1), with global minimum at imin, jmin
;
;  desire names of coordinates interior, jinterior
;
;  continguous with imin, jmin and under the level surface of chisq
;
iit=intarr(it+1,jt+1)
jjt=iit
for jkl=i0,it do begin
iit(jkl,*) = jkl
endfor
for jkl=j0,jt do begin
jjt(*,jkl)= jkl
endfor

nmax= max([jt-jmin, jmin-j0, it-imin, imin-i0])
itest=intarr(nmax+1,10*(nmax+1)) -999
jtest=intarr(nmax+1,10*(nmax+1)) -999
itest(0,0)=imin
jtest(0,0)=jmin
i_interior=itest
j_interior=jtest
;;;
;print,'nmax=', nmax,'i0,it,j0,jt,imin,jmin=', i0,it,j0,jt,imin,jmin
for jkl=1,nmax do begin
 n=jkl
  circle,n, imin,jmin, iring,jring, i0,it,j0,jt
   icheck=where(iring ge 0 and jring ge 0, n_check)
   if(n_check gt 0) then begin
    rlow=where( chisq(iring,jring) le level, npts)
;print, 'REPORT, n, npts',n, npts


   if(npts gt 0) then begin
    itest(n,0:npts-1)= (iit(iring,jring))(rlow)
    jtest(n,0:npts-1)= (jjt(iring,jring))(rlow)
   endif
;;;; now check for contiguous with preceeding ring
  iter_count=-1
    for iter=0, npts-1 do begin
     iname=itest(n,iter)
     jname=jtest(n,iter)
     itemp=where( $
 ((abs( iname-i_interior(n-1,*)) le 1 ) and $
  (abs( jname-j_interior(n-1,*)) le 1 ) ) $
          , npts_q)
         ; print, itemp,'itemp'
         ; print, abs( iname-i_interior(n-1,itemp(0)))
         ; print, abs( jname-j_interior(n-1,itemp(0)))
         ;print,n,iname, jname, npts_q, iter, 'n,iname,jname,npts_q,iter'

;stop
      if(npts_q gt 0) then begin  ;any match ok
        iter_count=iter_count+1
        i_interior(n, iter_count)=iname
        j_interior(n, iter_count)=jname
       ; print, 'updtating interiors i,j:',i_interior(n,iter_count),$
       ;       j_interior(n,iter_count), iter_count
        
      endif
    endfor
 endif;;;;;;;;;;;;;;have now completed the update of the contiguous
;;;;;;;;;;;;;; n'th ring less than level;;;;;;;;;
endfor


return
end   
;;;;dummy driver
x=(-500+findgen(1001))/50.
y=x
a=10
level=3*a/4.
z=fltarr(1001,1001)
for jkl=0,1000 do begin
z(jkl,*) = a -a/2.*exp(-(x(jkl)^2+y^2)/5 )+0*3*a/2*exp(-10*(x(jkl)^2+y^2)/5)$
   -a/2.1*exp(-((x(jkl)-3)^2+(y-3)^2)/3 )
endfor

contour, z,x,y, levels=min(z)*[1.03, 1.1, 1.5, 2.],xrange=[-3,3],$
  xstyle=1,ystyle=1, yrange=[-3,3]
minimum_z=min(z)
r=where(z eq min(z))
index_x=r(0) mod 1001
index_y=r(0)/1001

imin=index_x
jmin=index_y
i0=0
it=1000
j0=0
jt=1000
level=min(z)*1.03


;;;;;;;;
ring, z, imin,jmin, i0, it, j0, jt, level, i_interior, j_interior,nmax
;
r=where((i_interior ge 0) and (j_interior ge 0), npts_plot)
if(npts_plot gt 0) then $
  oplot, x(i_interior(r)), y(j_interior(r)),psym=1

end
