PRO SET_GIF, FILE = filename, ORIENTATION = orient, $
             LANDSCAPE=landscape, $
             FULL_PAGE=full_page, SCREEN_SIZE=screen_size, $
             WHITE_BACKGROUND=white, BLACK_BACKGROUND=black, $
             SWITCH_FOREGROUND_BACKGROUND=switch, $
             SET_CHARACTER_SIZE=charsize, $
             SIZE=size, number_pages=number_pages
   COMMON print_file, file_name, prev_device, present_device
   COMMON gif_colors, fore_color, back_color
   COMMON device_char, xsize_c, ysize_c, aspect_ratio
   COMMON page_numbers, page
;
;	No required Keywords.
;
; Handles printing to postscript devices
;
;	Parameters:
;		FILENAME = name of file
;		ORIENTATION = 'L' for Landscape, Portrait otherwise
;               /LANDSCAPE to landscape printing
;               /FULL_PAGE means full page size
;               /SCREEN_SIZE means 72 dpi ~8x8 in
;               /WHITE_BACKGROUND  means reverse normal color settings
;               /BLACK_BACKGROUND  means normal settings
;               /SWITCH_FOREGROUND_BACKGROUND  means reverse normal colors
;               SET_CHARACTER_SIZE=[width, line_separation]
;               SIZE=[xsize,ysize] overrides other sizing criteria 
;
;       N.B. This does not work with color yet!!!!
;
;
   if keyword_set(number_pages) then page=1 else page=0
   PREV_DEVICE0 = !D.NAME
   if (PREV_DEVICE0 NE 'Z') then begin
      SET_PLOT, 'Z'
      present_device = 'gif'
      DEVICE, z_buffering=0
      IF KEYWORD_SET(FILENAME) THEN file_name = filename $
      ELSE file_name = 'idl.gif'
      PREV_DEVICE = PREV_DEVICE0
   ENDIF

   IF KEYWORD_SET(FULL_PAGE) THEN BEGIN
      dpi = 300
      s1 = 10.0
      s2 = 7.5
      charsize0 = [32,48]
   ENDIF ELSE BEGIN
      IF KEYWORD_SET(SCREEN_SIZE) THEN BEGIN
         dpi = 72
         s1 = 8.0
         s2 = 8.0
         charsize0 = [6,9]
      ENDIF ELSE BEGIN 
         dpi = 300
         s1 = 8.0
         s2 = 6
         charsize0 = [32,48]
      ENDELSE 
   ENDELSE 
   size1 = dpi*s1
   size2 = dpi*s2

   IF (keyword_set(charsize)) THEN BEGIN
      device, set_character_size=charsize
   ENDIF ELSE BEGIN 
      device, set_character_size=charsize0
   ENDELSE 

   back_color = !p.background
   fore_color = !p.color
   IF ((keyword_set(white)) OR (keyword_set(switch))) THEN BEGIN
      !p.background = fore_color
      !p.color = back_color
   ENDIF 


   IF KEYWORD_SET(ORIENT) THEN BEGIN
      IF (strlowcase(STRMID(ORIENT,0,1)) EQ 'l') THEN BEGIN
         orient = 'L'
         xsiz = size1
         ysiz = size2
      ENDIF ELSE BEGIN
         orient = 'P'
         xsiz = size2
         ysiz = size1
      ENDELSE
   ENDIF ELSE BEGIN
      orient = 'P'
      xsiz = size2
      ysiz = size1
   ENDELSE
   IF KEYWORD_SET(LANDSCAPE) THEN BEGIN
      orient = 'L'
      xsiz = size1
      ysiz = size2
   ENDIF 
   device, set_resolution=[xsiz,ysiz]

   IF keyword_set(size) THEN BEGIN
      xsize_c = size(0)
      ysize_c = size(1)
   ENDIF ELSE BEGIN 
      xsize_c = xsiz
      ysize_c = ysiz
   ENDELSE 
   aspect_ratio = float(xsize_c)/float(ysize_c)

END



