PRO SET_PAGE, NHORIZ = nx, NVERT = ny, WAIT = wait_sec, DOWN = down
COMMON print_file, FILENAME, PREV_DEVICE, present_device
COMMON device_char, xsize, ysize, aspect_ratio
;
;	No required Keywords.
;
;	Sets number of plots horizontally and vertically and starts new page
;	Does aspect ratio calculations for devices 'PS' and 'X'
;
;	Parameters:
;		NHORIZ: number of plots horizontally (default 1)
;		NVERT:  number of plots vertically   (default 1)
;		WAIT:   sets the number of seconds to wait before clearing 
;			page if using 'X' device
;               DOWN: Sets to plot top-to-bottom, left-to-right
;                       Default is "ACCROSS" left-to-right, top-to-bottom
;
IF KEYWORD_SET(nx) THEN nh = nx ELSE nh = 1
IF KEYWORD_SET(ny) THEN nv = ny ELSE nv = 1
if keyword_set(down) then down=1 else down=0

if n_elements(present_device) eq 0 then present_device=!d.name
if n_elements(prev_device) eq 0 then prev_device=!d.name

!P.MULTI = [0, NH, NV, 0, down]
if (!d.name EQ 'X' or !d.name eq 'WIN') then begin
    device, get_screen_size = screen_size
    xsize = float(screen_size(0))
    ysize = float(screen_size(1))
    aspect_ratio = float(screen_size(0))/float(screen_size(1))
    DEFSYSV, '!timing', exists = i
    IF (i EQ 1) THEN BEGIN
        IF KEYWORD_SET(wait_sec) THEN wait, wait_sec
    ENDIF ELSE BEGIN
        DEFSYSV, '!timing', 1
    ENDELSE
endif else if (!d.name eq 'PS' or !d.name eq 'Z') then begin
    xsize = float(!d.x_size)
    ysize = float(!d.y_size)
    aspect_ratio = float(xsize)/float(ysize)
endif else begin
    if not keyword_set(xsize) then begin
        message, ' not defined for device '+!d.name+'.  Using default.', /cont
        xsize=1.0
        ysize=1.0
    endif
    aspect_ratio = float(xsize)/float(ysize)
endelse

!P.POSITION = [0,0,0,0]

END
