PRO SET_PAGE_DEBUG, NHORIZ = nx, NVERT = ny, WAIT = wait_sec
COMMON print_file, FILENAME, PREV_DEVICE, present_device
COMMON device_char, xsize, ysize, aspect_ratio
;
;	No required Keywords.
;
;	Sets number of plots horizontally and vertically and starts new page
;	Does aspect ratio calculations for devices 'PS' and 'X'
;
;	Parameters:
;		NHORIZ: number of plots horizontally (default 1)
;		NVERT:  number of plots vertically   (default 1)
;		WAIT:   sets the number of seconds to wait before clearing 
;			page if using 'X' device
;
;
;
IF KEYWORD_SET(nx) THEN nh = nx ELSE nh = 1
IF KEYWORD_SET(ny) THEN nv = ny ELSE nv = 1

!P.MULTI = [0, NH, NV, 0, 0]
print, 'Current device = ', !d.name
if (!d.name EQ 'X') then begin
   device, get_screen_size = screen_size
   xsize = float(screen_size(0))
   ysize = float(screen_size(1))
   aspect_ratio = float(screen_size(0))/float(screen_size(1))
   DEFSYSV, '!timing', exists = i
   IF (i EQ 1) THEN BEGIN
      IF KEYWORD_SET(wait_sec) THEN wait, wait_sec
   ENDIF ELSE BEGIN
      DEFSYSV, '!timing', 1
   ENDELSE
endif else begin
   aspect_ratio = float(xsize)/float(ysize)
endelse

!P.POSITION = [0,0,0,0]

END
