PRO SET_PCL, FILE = filename, ORIENTATION = orient, $
            INCHES = inches, RATIONAL = rational, $
            XOFFSET = xoffset_in, XSIZE = xsize_in, $
            YOFFSET = yoffset_in, YSIZE = ysize_in, COLOR = color, $
            landscape=landscape
COMMON print_file, file_name, prev_device, present_device
COMMON device_char, xsize_c, ysize_c, aspect_ratio
;
;	No required Keywords.
;
; Handles printing to pcl devices
;
;	Parameters:
;		FILENAME = name of file
;		ORIENTATION = 'L' for Landscape, Portrait otherwise
;		XOFFSET = left margin spacing
;		XSIZE = horizontal plot size
;		YOFFSET = bottom margin spacing
;		YSIZE = vertical plot size
;		/INCHES  if defined means size/offset values in inches
;		/RATIONAL  I have added a provision for offsets to 
;			behave as you (I) would expect 
;			(not default IDL (for landscape)).
;               /COLOR for color postscript
;               /LANDSCAPE to landscape printing
;
PREV_DEVICE0 = !D.NAME
if (PREV_DEVICE0 NE 'PCL') then begin
   SET_PLOT, 'PCL'
   spawn, 'echo $$', pid
   IF KEYWORD_SET(FILENAME) THEN file_name = filename $
                            ELSE file_name = 'idl_'+strtrim(pid(0),2)+'.pcl'

   print, file_name

   DEVICE, FILENAME = file_name
   PREV_DEVICE = PREV_DEVICE0
endif

IF KEYWORD_SET(ORIENT) THEN BEGIN
   IF (strlowcase(STRMID(ORIENT,0,1)) EQ 'l') THEN BEGIN
      DEVICE, /LANDSCAPE
      orient = 'L'
   ENDIF ELSE BEGIN
      DEVICE, /PORTRAIT 
      orient = 'P'
   ENDELSE
ENDIF ELSE BEGIN
   DEVICE, /PORTRAIT
   orient = 'P'
ENDELSE
IF KEYWORD_SET(LANDSCAPE) THEN BEGIN
      DEVICE, /LANDSCAPE
      orient = 'L'
ENDIF 

IF KEYWORD_SET(COLOR) THEN device, /color

IF KEYWORD_SET(INCHES) THEN BEGIN

   IF (ORIENT EQ 'P') THEN BEGIN
      IF KEYWORD_SET(XOFFSET_IN) THEN xoff = xoffset_in ELSE xoff = 0.75
      IF KEYWORD_SET(YOFFSET_IN) THEN yoff = yoffset_in ELSE yoff = 0.75

      IF KEYWORD_SET(XSIZE_IN) THEN xsiz = xsize_in ELSE xsiz = 7.0
      IF KEYWORD_SET(YSIZE_IN) THEN ysiz = ysize_in ELSE ysiz = 9.5

   ENDIF ELSE BEGIN
      IF KEYWORD_SET(XOFFSET_IN) THEN xoff = xoffset_in ELSE xoff = 0.75
      IF KEYWORD_SET(YOFFSET_IN) THEN yoff = yoffset_in ELSE yoff = 0.75

      IF KEYWORD_SET(XSIZE_IN) THEN xsiz = xsize_in ELSE xsiz = 9.5
      IF KEYWORD_SET(YSIZE_IN) THEN ysiz = ysize_in ELSE ysiz = 7

      IF (KEYWORD_SET(RATIONAL) AND KEYWORD_SET(XOFFSET_IN) AND $
          KEYWORD_SET(YOFFSET_IN)) THEN BEGIN
	 temp = xoff
	 xoff = yoff
	 yoff = 11 - temp
      ENDIF

   ENDELSE

   DEVICE, /INCHES, XOFFSET=xoff, YOFFSET=yoff, $
                    XSIZE=xsiz, YSIZE=ysiz

;	print, xoff,yoff,xsiz,ysiz

ENDIF ELSE BEGIN

   IF (ORIENT EQ 'P') THEN BEGIN
      IF KEYWORD_SET(XOFFSET_IN) THEN xoff = xoffset_in ELSE xoff = 1.905
      IF KEYWORD_SET(YOFFSET_IN) THEN yoff = yoffset_in ELSE yoff = 1.905

      IF KEYWORD_SET(XSIZE_IN) THEN xsiz = xsize_in ELSE xsiz = 17.78
      IF KEYWORD_SET(YSIZE_IN) THEN ysiz = ysize_in ELSE ysiz = 24.13
   ENDIF ELSE BEGIN
      IF KEYWORD_SET(XOFFSET_IN) THEN xoff = xoffset_in ELSE xoff = 1.905
      IF KEYWORD_SET(YOFFSET_IN) THEN yoff = yoffset_in ELSE yoff = 1.905

      IF KEYWORD_SET(XSIZE_IN) THEN xsiz = xsize_in ELSE xsiz = 24.13
      IF KEYWORD_SET(YSIZE_IN) THEN ysiz = ysize_in ELSE ysiz = 17.78

      IF (KEYWORD_SET(RATIONAL) AND KEYWORD_SET(XOFFSET_IN) AND $
	  KEYWORD_SET(YOFFSET_IN)) THEN BEGIN
	 temp = xoff
	 xoff = yoff
	 yoff = 27.94 - xoff
      ENDIF
   ENDELSE


   DEVICE, XOFFSET=xoff, YOFFSET=yoff, $
           XSIZE=xsiz, YSIZE=ysiz

;	print, xoff/2.54, yoff/2.54, xsiz/2.54, ysiz/2.54 

ENDELSE

xsize_c = xsiz
ysize_c = ysiz
aspect_ratio = float(xsize_c)/float(ysize_c)


END



