pro smear_append, smear_index, smear_times, smear_coords, xi, yi, wi, t, $
                  nx, ny, xr, yr
;
;    Append xi, yi, wi points to smear_* arrays.
;
;
append=0

if keyword_set(append) then begin

    if not keyword_set(smear_index) then begin
        smear_index=[[nx,ny],[nx,ny]]
        smear_coords=[[xr], [yr], [0,0]]
        smear_times=[[0],[0]]
    endif
    r=where(wi ne 0.0,nr)
    if r(0) ne -1 then begin
        ns=n_elements(smear_coords(*,0))
        nt=n_elements(t)
        smear_index=[[smear_index(*,0),ns],[smear_index(*,1),ns+nr-1]]
        smear_coords=[[smear_coords(*,0),xi(r)], $
                      [smear_coords(*,1),yi(r)], $
                      [smear_coords(*,2),wi(r)]]
        smear_times=[[smear_times(*,0),t(0)], $
                     [smear_times(*,1),t(nt-1)]]
        
    endif
endif else begin
    n1=50000
    n2=1000
    if not keyword_set(smear_index) then begin
        smear_index=lonarr(n2+1,2)
        smear_coords=fltarr(n1,3)
        smear_times=dblarr(n2,2)

        smear_index(0:1,0)=[nx,ny]
        smear_index(0:1,1)=[2,2]
        smear_coords(0:1,0)=xr
        smear_coords(0:1,1)=yr
        smear_coords(0:1,2)=0.0
        smear_times(0,*)=0.d0
    endif
    r=where(wi ne 0.0,nr)
    if r(0) ne -1 then begin

        ii=smear_index(0,1)
        it=ii-1
        ic=smear_index(1,1)
        ice=ic+nr-1
        nt=n_elements(t)

        ni=(size(smear_times, /dimensions))(0)
        if ii ge ni then begin
            smear_index=hyd_expand_array(temporary(smear_index), [ni+n2+1,2])
            smear_times=hyd_expand_array(temporary(smear_times), [ni+n2,2])
        endif
        nc=(size(smear_coords, /dimensions))(0)
        while (nc le ice) do begin
            smear_coords=hyd_expand_array(temporary(smear_coords), [nc+n1,3])
            nc=(size(smear_coords, /dimensions))(0)
        endwhile

        smear_index(ii,0)=ic
        smear_index(ii,1)=ic+nr-1
        smear_times(it,0)=t(0)
        smear_times(it,1)=t(nt-1)
        smear_coords(ic:ice,0)=xi(r)
        smear_coords(ic:ice,1)=yi(r)
        smear_coords(ic:ice,2)=wi(r)

        smear_index(0,1)=ii+1
        smear_index(1,1)=ice+1
    endif
endelse

return
end

