pro smear_connect_the_dot, smear_times, smear_index, smear_coords, $
                           smear_coords_times, $
                           gs=gs, limits=limits, nx=nx, ny=ny
;
;  Connect the 18ms "dots" in the input smear.  Output replaces the input
;  variables.
;
;

;
;  1) Take input smears and create a sequence of segments
;  2) For each time-interval, call smear_line
;  3) Reconstruct the new smear_sequence.
;
nt=n_elements(smear_times(*,0))-1

smear_times_new=smear_times
smear_index_new=smear_index
smear_coords_new=smear_coords

i1_new=1
;for i=0L, nt-1 do begin
for i=1L, nt-1 do begin
    i0=smear_index(i+2,0)
    i1=smear_index(i+2,1)
    x=smear_coords(i0:i1,0)
    y=smear_coords(i0:i1,1)
    w=smear_coords(i0:i1,2)
    t=smear_coords_times(i0:i1)

    r=where(t ne -1,nr)
    if nr gt 0 then begin
        x=x(r)
        y=y(r)
        t=t(r)

        if i gt 0 then begin
            i10=smear_index(i+1,1)
            x0=smear_coords(i10:i10,0)
            y0=smear_coords(i10:i10,1)
            w0=smear_coords(i10:i10,2)
            t0=(smear_coords_times(i10:i10))(0)
            if abs(t(0)-t0) lt 0.019 then begin
                if t0 lt smear_times(i+1,0) then begin
                    x0=x0+(x(0)-x0)/(t(0)-t0)*(smear_times(i+1,0)-t0)
                    y0=y0+(y(0)-y0)/(t(0)-t0)*(smear_times(i+1,0)-t0)
                    t0=smear_times(i+1,0)
                endif else begin
                    x0=[x0+(x(0)-x0)/(t(0)-t0)*(smear_times(i+1,0)-t0),x0]
                    y0=[y0+(y(0)-y0)/(t(0)-t0)*(smear_times(i+1,0)-t0),y0]
                    t0=[smear_times(i+1,0),t0]
                endelse
                x=[x0,x]
                y=[y0,y]
                w=[w0,w]
                t=[t0,t]
            endif else begin
                ntx=n_elements(x)
                if ntx gt 1 then begin
                    x0=x(0)+(x(1)-x(0))/(t(1)-t(0))*(smear_times(i+1,0)-t(0))
                    y0=y(0)+(y(1)-y(0))/(t(1)-t(0))*(smear_times(i+1,0)-t(0))
                    t0=smear_times(i+1,0)
                    x=[x0,x]
                    y=[y0,y]
                    w=[w0,w]
                    t=[t0,t]
                endif
            endelse
        endif
        if i lt nt-1 then begin
            i01=smear_index(i+3,0)
            x1=smear_coords(i01:i01,0)
            y1=smear_coords(i01:i01,1)
            w1=smear_coords(i01:i01,2)
            t1=(smear_coords_times(i01:i01))(0)
            if abs(t1-t(n_elements(t)-1)) lt 0.019 then begin
                ntx=n_elements(x)
                if t1 gt smear_times(i+1,1) then begin
                    x1=x(ntx-1)+$
                      (x1-x(ntx-1))/(t1-t(ntx-1))*(smear_times(i+1,1)-t(ntx-1))
                    y1=y(ntx-1)+$
                      (y1-y(ntx-1))/(t1-t(ntx-1))*(smear_times(i+1,1)-t(ntx-1))
                    t1=smear_times(i+1,1)
                endif else begin
                    x1=[x1,x(ntx-1)+$
                        (x1-x(ntx-1))/(t1-t(ntx-1))*(smear_times(i+1,1)-t(ntx-1))]
                    y1=[y1,y(ntx-1)+$
                        (y1-y(ntx-1))/(t1-t(ntx-1))*(smear_times(i+1,1)-t(ntx-1))]
                    t1=[t1,smear_times(i+1,1)]
                endelse
                x=[x,x1]
                y=[y,y1]
                w=[w,w1]
                t=[t,t1]
            endif else begin
                ntx=n_elements(x)
                if ntx gt 1 then begin
                    dxdt=(x(ntx-1)-x(ntx-2))/(t(ntx-1)-t(ntx-2))
                    dydt=(y(ntx-1)-y(ntx-2))/(t(ntx-1)-t(ntx-2))
                    x1=x(ntx-1)+dxdt*(smear_times(i+1,1)-t(ntx-1))
                    y1=y(ntx-1)+dydt*(smear_times(i+1,1)-t(ntx-1))
                    t1=smear_times(i+1,1)
                    x=[x,x1]
                    y=[y,y1]
                    w=[w,w1]
                    t=[t,t1]
                endif
            endelse
            
            if t(0) gt smear_times(i+1,0) then begin
                i10=smear_index(i+1,1)
                x0=smear_coords(i10:i10,0)
                y0=smear_coords(i10:i10,1)
                w0=smear_coords(i10:i10,2)
                t0=(smear_coords_times(i10:i10))(0)
                if abs(t(0)-t0) lt 0.019 then begin
                    if t0 lt smear_times(i+1,0) then begin
                        x0=x0+(x(0)-x0)/(t(0)-t0)*(smear_times(i+1,0)-t0)
                        y0=y0+(y(0)-y0)/(t(0)-t0)*(smear_times(i+1,0)-t0)
                        t0=smear_times(i+1,0)
                    endif else begin
                        x0=[x0+(x(0)-x0)/(t(0)-t0)*(smear_times(i+1,0)-t0),x0]
                        y0=[y0+(y(0)-y0)/(t(0)-t0)*(smear_times(i+1,0)-t0),y0]
                        t0=[smear_times(i+1,0),t0]
                    endelse
                    x=[x0,x]
                    y=[y0,y]
                    w=[w0,w]
                    t=[t0,t]
                endif else begin
                    ntx=n_elements(x)
                    if ntx gt 1 then begin
                        x0=x(0)+(x(1)-x(0))/(t(1)-t(0))*(smear_times(i+1,0)-t(0))
                        y0=y(0)+(y(1)-y(0))/(t(1)-t(0))*(smear_times(i+1,0)-t(0))
                        t0=smear_times(i+1,0)
                        x=[x0,x]
                        y=[y0,y]
                        w=[w0,w]
                        t=[t0,t]
                    endif
                endelse
            endif
        endif
    endif
    ;stop
    ntx=n_elements(x)
    if (x(0) eq 1e6) or (nr eq 0) or (ntx lt 2) then begin
        smear_index_new(i+2,*)=[-1,-1]        
    endif else begin
        x0=x(0:ntx-2)
        y0=y(0:ntx-2)
        x1=x(1:ntx-1)
        y1=y(1:ntx-1)

        dt=t(1:*)-t
        hd_make_timetags, timetags, t(0:ntx-2), dt, $
          /ssm, dateyyyymmdd=19960529


        if (where(finite([x0,x1,y0,y1]) eq 0))(0) ne -1 then stop

        smear_pixels=smear_line(timetags, $
                                x0, x1, y0, y1, $
                                gs=gs, limits=limits, nx=nx, ny=ny)

        if smear_pixels(0,0) eq -1 then begin
            smear_index_new(i+2,*)=[-1,-1]        
        endif else begin
            x_new=smear_pixels(*,0)
            y_new=smear_pixels(*,1)
            w_new=smear_pixels(*,3)*86400.d0
            i0_new=i1_new+1
            i1_new=i0_new+n_elements(smear_pixels(*,0))-1
            if i1_new ge n_elements(smear_coords_new(*,0)) then begin
                smear_coords_new=[[smear_coords_new], [fltarr(1000,3)]]
            endif
            smear_coords_new(i0_new:i1_new,*)=[x_new,y_new,w_new]
            smear_index_new(i+2,*)=[i0_new,i1_new]
        endelse
    endelse
endfor
smear_coords_new=smear_coords_new(0:i1_new+1,*)
smear_coords_new(i1_new+1,*)=[-1e6,-1e6,0.0]
ifill=i1_new+1
r=where(smear_index_new eq -1, nr)
if nr gt 0 then smear_index_new(r)=ifill

stop

smear_times=smear_times_new
smear_index=smear_index_new
smear_coords=smear_coords_new

end
