function smear_rhist, x0_in, x1_in, gsx, limitsx, weight
  
  if x0_in lt x1_in then begin
      x0= x0_in
      x1= x1_in
  endif else begin
      x0= x1_in
      x1= x0_in      
  endelse
  
  binsize= gsx
  min= limitsx[0]
  max= limitsx[1]
  
  nh= long( ( max-min ) / binsize ) + 1
  result= make_array( nh, type=size(weight,/type) )
  nresult=n_elements(result)

  ibin0= floor((x0-min)/binsize)
  invN0= ( (min+(ibin0+1)*binsize) - x0 ) / binsize
  ibin1= floor((x1-min)/binsize)
  invN1= ( x1 - ( (min+(ibin1*binsize)) ) ) / binsize
  invN= 1
 
  TT= total( invN0 + invN1 + invN*(ibin1-ibin0-1) )
  
  if TT ne 0.0 then begin
      if invN0 gt 0. and $
        ibin0 ge 0 and ibin0 lt nh and $
        ibin0 lt ibin1 then $
        result(ibin0)= invN0/TT * weight
      if invN1 gt 0. and $
        ibin1 lt nh and ibin1 ge 0 and $
        ibin0 lt ibin1 then $
        result(ibin1)= invN1/TT * weight
      if ibin1-ibin0 gt 1 then begin
          idx= indgen( (ibin1-1)-(ibin0+1)+1 ) + (ibin0+1)
          r= where( idx ge 0 and idx lt nh )
          if r(0) ne -1 then $
            result(idx(r))= invN/TT * weight
      endif else if ibin0 eq ibin1 then begin
          if ibin0 ge 0 and ibin0 lt nresult then begin
              result(ibin0)= 1. * weight
          endif
      endif
  endif
  
  return, result
  
end
  
pro test_smear_line
   @hd_include 
   timetags= replicate( hd_timetag_struct, 2 )
   timetags.bin_start= 150. 
   timetags.bin_width= 13.8  
   y0= [ 0.5, 5.4 ]
   y1= [ 5.4, -4.3 ]
   x0= [ 1.2, 4.3 ]
   x1= [ 4.3, 4.0 ] 
   limits=[-10,-10,10,10]
   nx=20
   ny=20

   restore, '/home/jbf/bugs/smear_line_input.idlsav'
   smear= smear_line( timetags, x0, x1, y0, y1, limits=limits, nx=nx, ny=ny, $
                      gs=gs ) ; gs is output--nx,ny override.
   
   plot, [x0,x1], [y0,y1], /nodata, back=!cs.grey, $
     xrange=limits([0,2]), yrange=limits([1,3])
   for i=0,n_elements(timetags)-1 do $
     oplot, [ x0[i],x1[i] ], [ y0[i],y1[i] ]

   for i= ceil(!x.crange[0]), floor(!x.crange[1]) do oplot, [i,i], !y.crange
   for i= ceil(!y.crange[0]), floor(!y.crange[1]) do oplot, !x.crange, [i,i]
   
   dots, /fill
   hydra_digiplot, /overplot, $
     x=(smear(*,0)+0.5)*gs[0]+limits[0], $
     y=(smear(*,1)+0.5)*gs[1]+limits[1], z=smear(*,3), psym=8, $
     format='(f9.1)'

   stop

end

function smear_line, timetags, x0, x1, y0, y1, $
                     gs=gs, limits=limits_in, $
                     nx=nx, ny=ny

  limits= double( limits_in )
  
  if n_elements( nx ) ne 0 then begin
      gs= ( limits[2:3]-limits[0:1] ) / [ nx, ny ]
  endif else begin
      n= ceil( ( limits[2:3]-limits[0:1] ) / gs )
      nx= n[0]
      ny= n[1]
  endelse

  weight= fltarr(nx,ny)
  
  smear= dblarr( 10, 4 ) ; icol, irow, itimetag, weight
  ismear= 0L

  slope= ( y1-y0 ) / double( x1-x0 )

  for i=0,n_elements(timetags)-1 do begin

      if ( abs(slope[i]) lt 1.0 ) then begin
          
          y_min= y0[i]<y1[i]
          y_max= y0[i]>y1[i]

          row_dist= smear_rhist( y0[i], y1[i], gs[1], limits[[1,3]], $
                                 timetags[i].bin_width )
          r= where( row_dist gt 0., count )
          for ir= 0,count-1 do begin
              y0_1= r[ir]*gs[1] + limits[1] > y_min
              y1_1= (r[ir]+1)*gs[1] + limits[1] < y_max
              x0_1= x0[i] + ( y0_1 - y0[i] ) / slope[i]
              x1_1= x0[i] + ( y1_1 - y0[i] ) / slope[i]
              col_dist= smear_rhist( x0_1, x1_1, gs[0], limits[[0,2]], $
                                     row_dist[r[ir]] )
              r2= where( col_dist gt 0., count2 )
              for ir2= 0,count2-1 do begin
                  smear[ismear,*]= [ r2[ir2], r[ir], i, col_dist[r2(ir2)] ]
                  ismear= ismear+1
                  if ismear ge n_elements(smear)/4 then begin
                      smear= [ smear, dblarr(10,4) ]
                  endif
              endfor
          endfor  
        
      endif else begin

          x_min= x0[i]<x1[i]
          x_max= x0[i]>x1[i]

          col_dist= smear_rhist( x0[i], x1[i], gs[0], limits[[0,2]], $
                                 timetags[i].bin_width )
          r= where( col_dist gt 0., count )
          for ir= 0,count-1 do begin
              x0_1= r[ir]*gs[0] + limits[0] > x_min
              x1_1= (r[ir]+1)*gs[0] + limits[0] < x_max
              y0_1= y0[i] + ( x0_1 - x0[i] ) * slope[i]
              y1_1= y0[i] + ( x1_1 - x0[i] ) * slope[i]
              row_dist= smear_rhist( y0_1, y1_1, gs[1], limits[[1,3]], $
                                     col_dist[r[ir]] )
              r2= where( row_dist gt 0., count2 )
              for ir2= 0,count2-1 do begin
                  smear[ismear,*]= [ r[ir], r2[ir2], i, row_dist[r2(ir2)] ]
                  ismear= ismear+1
                  if ismear ge n_elements(smear)/4 then begin
                      smear= [ smear, dblarr(10,4) ]
                  endif
              endfor
          endfor  

      endelse
  endfor

  if ismear gt 0 then begin
      smear= smear[ 0:(ismear-1),* ] 
  endif else begin
      smear= transpose( [ -1,-1,-1,-1. ] )
  endelse
  return, smear

end  
