pro smear_matrix_average, smear_coords, smear_index, smear_times, $
                          z, xx,yy,zz,vzz,ww,matrix=matrix, $
                          avg_method=avg_method
;
;   Average the smears on the grid
;
;
nx=smear_index(0,0)
ny=smear_index(1,0)

xg=(smear_coords(1,0)-smear_coords(0,0))*$
  (findgen(smear_index(0,0))+0.5)/float(nx)+smear_coords(0,0)
yg=(smear_coords(1,1)-smear_coords(0,1))*$
  (findgen(smear_index(1,0))+0.5)/float(ny)+smear_coords(0,1)

matrix_w=fltarr(nx, ny)
matrix_z=fltarr(nx, ny)
matrix_vz=fltarr(nx, ny)
matrix_n=lonarr(nx,ny)

ni=n_elements(smear_index(*,0))
si=smear_index(2:*,*)
si(*,0)=-si(*,0)
npi=total(si,2)+1
npit=total(npi)

xi=fltarr(npit)
yi=fltarr(npit)
zi=fltarr(npit)
wi=fltarr(npit)

i0=0
for i=2L,ni-1 do begin
    i1=i0+npi(i-2)-1
    xi(i0:i1)=smear_coords(smear_index(i,0):smear_index(i,1),0)
    yi(i0:i1)=smear_coords(smear_index(i,0):smear_index(i,1),1)
    zi(i0:i1)=z(i-2)
    wi(i0:i1)=smear_coords(smear_index(i,0):smear_index(i,1),2)
    i0=i1+1
endfor

r=where(xi ge 0 and xi lt nx and yi ge 0 and yi lt ny)
if (r(0) ne -1) then begin
    case avg_method of
        'A': begin
            print, 'Accumulation...Avg'
            for i=0L, n_elements(r)-1 do begin
                ix=xi(r(i))
                iy=yi(r(i))
                iz=zi(r(i))
                iw=wi(r(i))
                matrix_z(ix,iy)=matrix_z(ix,iy)+iz*iw
                matrix_w(ix,iy)=matrix_w(ix,iy)+iw
                matrix_n(ix,iy)=matrix_n(ix,iy)+1
            endfor
            print, 'Variance...'
            for i=0L, n_elements(r)-1 do begin
                ix=xi(r(i))
                iy=yi(r(i))
                iz=zi(r(i))
                iw=wi(r(i))
                matrix_vz(ix,iy)=matrix_vz(ix,iy)+$
                  iw*(iz-matrix_z(ix,iy)/matrix_w(ix,iy))^2
            endfor
        end
        'B': begin              ; Max
            print, 'Accumulation...Max'
            matrix_z=replicate(-1e31,nx, ny)
            for i=0L, n_elements(r)-1 do begin
                ix=xi(r(i))
                iy=yi(r(i))
                iz=zi(r(i))
                iw=wi(r(i))
                matrix_z(ix,iy)=max([matrix_z(ix,iy),iz])
                matrix_w(ix,iy)=matrix_w(ix,iy)+iw
                matrix_n(ix,iy)=matrix_n(ix,iy)+1
            endfor
        end
        'C': begin              ; Min
            print, 'Accumulation...Min'
            matrix_z=replicate(1e31,nx, ny)
            for i=0L, n_elements(r)-1 do begin
                ix=xi(r(i))
                iy=yi(r(i))
                iz=zi(r(i))
                iw=wi(r(i))
                matrix_z(ix,iy)=min([matrix_z(ix,iy),iz])
                matrix_w(ix,iy)=matrix_w(ix,iy)+iw
                matrix_n(ix,iy)=matrix_n(ix,iy)+1
            endfor
        end
        'D': begin              ; |Max|
            print, 'Accumulation...|Max|'
            for i=0L, n_elements(r)-1 do begin
                ix=xi(r(i))
                iy=yi(r(i))
                iz=zi(r(i))
                iw=wi(r(i))
                iz=[matrix_z(ix,iy),iz]
                max=max(abs(iz),im)
                matrix_z(ix,iy)=iz(im)
                matrix_w(ix,iy)=matrix_w(ix,iy)+iw
                matrix_n(ix,iy)=matrix_n(ix,iy)+1
            endfor
        end
    endcase
endif
r=where(matrix_w gt 0,nr)
if nr gt 0 then begin
    i=r mod nx
    j=r/nx
    xx=xg(i)
    yy=yg(j)
    case avg_method of
        'A': begin
            print, 'Averaging...points'
            zz=matrix_z(r)/matrix_w(r)
            vzz=sqrt(matrix_vz(r)/matrix_w(r))
        end
        else: begin
            zz=matrix_z(r)
            vzz=replicate(0.0,nr)
        end
    endcase
    ww=matrix_w(r)
endif
if keyword_set(matrix) then begin
    print, 'Averaging...matrix.'
    matrix=fltarr(nx*ny,3)
    matrix(r,0)=matrix_z(r)/matrix_w(r)
    matrix(r,1)=sqrt(matrix_vz(r)/matrix_w(r))
    matrix(r,2)=float(matrix_n(r))
    matrix=reform(matrix,nx,ny,3,/overwrite)
endif
print, 'Averaging...done.'
return
end
