pro smear_midpoint, smear_coords, smear_index, smear_times, $
                    z, xx,yy,ww,zz,vzz, matrix=matrix, $
                    midpoint_average=midpoint_average, $
                    avg_method=avg_method
;
;       Return midpoints: averaging if desired.
;
;
;
rfill=-1e31

nx=smear_index(0,0)
ny=smear_index(1,0)
xg=(smear_coords(1,0)-smear_coords(0,0))*$
  (findgen(smear_index(0,0))/float(nx)+0.5)+smear_coords(0,0)
yg=(smear_coords(1,1)-smear_coords(0,1))*$
  (findgen(smear_index(1,0))/float(ny)+0.5)+smear_coords(0,1)

np=n_elements(smear_coords(*,0))-1
n0=smear_index(2,0)
xi=smear_coords(n0:np,0)
yi=smear_coords(n0:np,1)
ni=n_elements(smear_index(*,0))
index0=[smear_index(2:ni-1,0)]
index1=[smear_index(2:ni-1,1)]

ni=ni-1
index=0.5*(index0(0:ni-2)+index1(0:ni-2))
xi=xi(index)
yi=yi(index)
zi=z

r=where(xi ge 0 and xi lt nx and yi ge 0 and yi lt ny)
if r(0) ne -1 then begin
    xx=xg(xi(r))
    yy=yg(yi(r))
    zz=z(r)
    vzz=z(r)
endif else begin
    xx=rfill
    yy=rfill
    zz=rfill
    vzz=rfill
    ww=rfill
endelse


if midpoint_average then begin
    matrix_w=fltarr(nx, ny)
    matrix_z=replicate(0.0,nx, ny)
    matrix_vz=fltarr(nx, ny)
    matrix_n=lonarr(nx, ny)
    wi=replicate(1.0,n_elements(index))

    r=where(xi ge 0 and xi lt nx and yi ge 0 and yi lt ny)
    if (r(0) ne -1) then begin
        case avg_method of
            'A': begin
                print, 'MidPoint Accumulation...Avg'
                for i=0L, n_elements(r)-1 do begin
                    ix=xi(r(i))
                    iy=yi(r(i))
                    iz=zi(r(i))
                    iw=wi(r(i))
                    matrix_z(ix,iy)=matrix_z(ix,iy)+iz*iw
                    matrix_w(ix,iy)=matrix_w(ix,iy)+iw
                    matrix_n(ix,iy)=matrix_n(ix,iy)+1
                endfor
                print, 'MidPoint Variance...'
                for i=0L, n_elements(r)-1 do begin
                    ix=xi(r(i))
                    iy=yi(r(i))
                    iz=zi(r(i))
                    iw=wi(r(i))
                    matrix_vz(ix,iy)=matrix_vz(ix,iy)+$
                      iw*(iz-matrix_z(ix,iy)/matrix_w(ix,iy))^2
                endfor
            end
            'B': begin          ; Max
                print, 'MidPoint Accumulation...Max'
                matrix_z=replicate(-1e31,nx, ny)
                for i=0L, n_elements(r)-1 do begin
                    ix=xi(r(i))
                    iy=yi(r(i))
                    iz=zi(r(i))
                    iw=wi(r(i))
                    matrix_z(ix,iy)=max([matrix_z(ix,iy),iz])
                    matrix_w(ix,iy)=matrix_w(ix,iy)+iw
                    matrix_n(ix,iy)=matrix_n(ix,iy)+1
                endfor                
            end
            'C': begin          ; Min
                print, 'MidPoint Accumulation...Min'
                matrix_z=replicate(1e31,nx, ny)
                for i=0L, n_elements(r)-1 do begin
                    ix=xi(r(i))
                    iy=yi(r(i))
                    iz=zi(r(i))
                    iw=wi(r(i))
                    matrix_z(ix,iy)=min([matrix_z(ix,iy),iz])
                    matrix_w(ix,iy)=matrix_w(ix,iy)+iw
                    matrix_n(ix,iy)=matrix_n(ix,iy)+1
                endfor
            end
            'D': begin          ; |Max|
                print, 'MidPoint Accumulation...|Max|'
                for i=0L, n_elements(r)-1 do begin
                    ix=xi(r(i))
                    iy=yi(r(i))
                    iz=zi(r(i))
                    iw=wi(r(i))
                    iz=[matrix_z(ix,iy),iz]
                    zmax=max(abs(iz),im)
                    matrix_z(ix,iy)=iz(im)
                    matrix_w(ix,iy)=matrix_w(ix,iy)+iw
                    matrix_n(ix,iy)=matrix_n(ix,iy)+1
                endfor
            end
        endcase

    endif
    r=where(matrix_w gt 0,nr)
    if nr gt 0 then begin
        i=r mod nx
        j=r/nx
        xx=xg(i)
        yy=yg(j)

        case avg_method of
            'A': begin
                print, 'MidPoint Averaging...points'
                zz=matrix_z(r)/matrix_w(r)
                vzz=sqrt(matrix_vz(r)/matrix_w(r))
            end
            else: begin
                zz=matrix_z(r)
                vzz=replicate(0.0, nr)
            end
        endcase
        ww=matrix_w(r)
    endif else begin
        xx=[rfill]
        yy=[rfill]
        zz=[rfill]
        vzz=[rfill]
    endelse
    if keyword_set(matrix) then begin

        message, 'Return Matrix section not coded.'

        print, 'MidPoint Averaging...matrix.'
        matrix=fltarr(nx*ny,3)
        matrix(r,0)=matrix_z(r)/matrix_w(r)
        matrix(r,1)=sqrt(matrix_vz(r)/matrix_w(r))
        matrix(r,2)=matrix_n(r)
        matrix=reform(matrix,nx,ny,3,/overwrite)
    endif
    print, 'MidPoint Averaging...done.'
endif

return
end

