pro test_smear_position
;
;   Test a case
;

   time_start=5*3600.d0+4.6*indgen(100)
   time_width=replicate(3.45,100)
   hd_make_timetags, timetags, time_start, time_width, $
     /ssm, dateYYYYMMDD=19960529, /width_seconds

   smear_position_from_time, timetags, ix, iz, $
     xrange=[-1,1], yrange=[-1,1], dimensions=[250,250]


return
end


pro smear_position_from_time, timetags, ix, iz, $
                              xrange=xr, yrange=zr, dimensions=dimensions, $
                              mfe_8hz=mfe_8hz, angle_filter=angle_filter
;
;    Input:
;           timetags
;
;    Keyword Input:
;           xrange=[x_Lo,x_High]
;           yrange=[z_Lo,z_High]
;           dimensions=[nx,ny]:       of Smear Matrix
;           /mfe_8hz:                 Uses Mfe 8Hz Data interpolated
;                                          to 54Hz.
;
;    Output:
;           ix, iz:   Indexes to Smear Matrix
;
;

;
;    Get Separator Coordinates
;
    hyd_get_separator_coords, txs, xs, tzs, zs, generator='jds', $
      mfe_8hz=mfe_8hz, angle_filter=angle_filter
    xs=-xs
    zs=-zs

    tstart=(timetags.bin_start-150)*86400.d0
    tend=tstart+timetags.bin_width*86400.d0

    n=n_elements(tstart)
    intervals=tstart(1:*)-tstart
    max=max(intervals,min=min)
    interval=total(intervals)/float(n-1)
    if (max-min)/intervals(0) gt 0.01 then begin
        nintervals=intervals/min

        r= where(nintervals-fix(nintervals) gt 0.1,nr)
        if nr eq 0 then begin
            ntot=total(fix(nintervals))
            tt=timetags(0)
            tt.bin_start=-1e31
            ttags=replicate(tt,ntot)
            i=0
            for i1=0,n-1 do begin
                ttags(i)=timetags(i0)
                for j=1,nintervals(i)-1 do $
                  ttags(i+j).bin_start=$
                  ttags(i+j-1).bin_start+intervals(i)/86400.d0
                i=i+nintervals(i)
            endfor
            tstart=(ttags.bin_start-150)*86400.d0
            tend=tstart+ttags.bin_width*86400.d0

        endif else begin
            print, 'ERROR: require fixed intervals'
            stop
        endelse
    endif


    if not keyword_set(dimensions) then dimensions=[250,250]
    if not keyword_set(xr) then xr=[-1,1]
    if not keyword_set(zr) then zr=[-1,1]

    plot_separator_dots, tstart, tend, xs, txs, zs, tzs, $
      dimensions=dimensions, xrange=xr, yrange=zr, $
      smear_coords=smear_coords, $
      smear_index=smear_index, smear_times=smear_times, $
      interval=interval


    tstart=smear_times(1:*,0)
    tend=smear_times(1:*,1)
    index_start=smear_index(2:*,0)-2
    index_end=smear_index(2:*,1)-2

    nx=index_end(n_elements(tstart)-1)+2
    x=smear_coords(2:nx,0)
    z=smear_coords(2:nx,1)
    w=smear_coords(2:nx,2)
    stop



return
end
