function smooth_weight, a, weight=weight, fill=fill
;
;   Smooth a 2D array by applying the weight matrix to the area around
;   each point.  The edge bands are preserved.
;
;
;   Weight Matrix should be odd dimensions
;
if not keyword_set(fill) then fill=-1e31
;
;   Define Size of weight matrix and Center for offsets
;
ns=size(weight,/dimensions)
centers=(ns-1)/2
;
;   Define size of sub-matrix to be extracted
;
nas=size(a, /dimensions)-2*centers
;
;   Start with zero for all elements: Numerator x, Denominator y
;
x=a(centers(0):nas(0),centers(1):nas(1))
x(*)=0
y=x
;
;   Add each weighted sub-matrix
;
for j=0,ns(1)-1 do begin
    joffset=j-centers(1)
    for i=0,ns(0)-1 do begin
        ioffset=i-centers(0)
        numerator=a(centers(0)+ioffset:nas(0)+ioffset,$
              centers(1)+joffset:nas(1)+joffset)
        denominator=make_array(size=size(numerator), value=1.0)
        r=where(numerator eq fill)
        if r(0) ne -1 then numerator(r)=0.0
        if r(0) ne -1 then denominator(r)=0.0
        x=x+weight(i,j)*numerator
        y=y+weight(i,j)*denominator
    endfor
endfor
r=where(y eq 0,nr)
y(r)=1.0
x=x/y
x(r)=fill
;
;   Preserve the edges
;
m=a
m(centers(0):nas(0),centers(1):nas(1))=x

return, m
end
