FUNCTION strtrim_rdh, number, index
;+
; NAME:
;      STRTRIM_RDH
;
; PURPOSE:
;      Wrapper for STRTRIM that formats real numbers to eliminate
;      trailing zeros.
;
; CATEGORY:
;      Utility.
;
; CALLING SEQUENCE:
;      s = STRTRIM_RDH(number, index)
; 
; INPUTS:
;      number: The number to be converted to string.
;      index: 0 = remove trailing blanks, 
;             1 = remove leading blanks,
;             2 = remove both leading and trailing blanks.
;
; OPTIONAL INPUTS:
;      None.
;	
; KEYWORD PARAMETERS:
;      None.
;
; OUTPUTS:
;      Number converted to a String without any trailing zeros.
;
; OPTIONAL OUTPUTS:
;      None.
;
; COMMON BLOCKS:
;      None.
;
; SIDE EFFECTS:
;      None.
;
; RESTRICTIONS:
;      None.
;
; PROCEDURE:
;      Search string for trailing zeros and eliminate.
;
; EXAMPLE:
;      s = STRTRIM_RDH(9.90, 2)
;      help, s
;
; MODIFICATION HISTORY:
;      $Log: strtrim_rdh.pro,v $
;      Revision 1.1  1998/11/17 21:29:07  rdh
;      Initial revision
;
;-

   result = strtrim(number,index)

   i0 = strlen(result)-1
   i = i0
   letter = strmid(result,i,1)
   WHILE ((letter EQ '0') AND (i GT 0)) DO BEGIN
      i = i-1
      letter = strmid(result,i,1)
   ENDWHILE 
   res = strmid(result,0,i+1) 
   return, res
END

