pro time_stamp, label=label, color=color, charsize=charsize

stamp = 'plotted : '+systime()
if not keyword_set(charsize) then charsize=1.0

if (getenv('TERM') eq 'vt300-80') then begin
   chsize = 1.0*charsize
   xpos = 0.975
endif else BEGIN
   chsize = 0.5*charsize
   xpos = 1.0
ENDELSE

IF keyword_set(label) THEN stamp = stamp+' '+label

if (keyword_set(color)) then $
  xyouts,xpos,0.5,/norm,/noclip,orient=90.0,align=0.5,size=chsize,$
  color=color,stamp $
else $
  xyouts,xpos,0.5,/norm,/noclip,orient=90.0,align=0.5,size=chsize,stamp

return
end
