PRO write_edit_data, date, log, label
;
;  Write the label to the log file specified by log and date
;
;  Date is in yyyymmdd format
;  log is the name of the file (.log will be appended).
;  label is the lines to append to the file.
;
   dir = '/opt/hydra/edit_data/'+strtrim(date,2)
   file = dir+'/'+log+'.log'

   
   spawn, 'mkdir '+dir+' 2> /dev/null;chmod 775 '+dir, /sh
   spawn, 'touch '+file+';chmod 664 '+file
   openu, unit, file, /append, /get_lun
   printf, unit, label
   close, unit
   free_lun, unit

   return
END

