PRO write_global_att, id, att_name, label, date, force=force, log=log
;
;  Write a Global Attribute to a cdf file
;
;  Attribute att_name is written label as an entry. 
;  (Appended if it already exists. )
;
;
   ai = cdf_inquire(id)
   na = ai.natts
   names = strarr(na)
   nes = intarr(na)
   ia = 0
   FOR i=0,na-1 DO BEGIN
      cdf_attinq, id, i, name, scope, maxr, maxz
      IF (scope EQ 'GLOBAL_SCOPE') THEN BEGIN
         names(ia) = name
         nes(ia) = maxr
         ia=ia+1
      ENDIF 
   ENDFOR 
   names = names(0:ia-1)
   nes = nes(0:ia-1)
   in = 0
   while (names(in) NE att_name AND in LT ia-1) DO in = in+1
   IF names(in) NE att_name THEN BEGIN
      r = cdf_attcreate(id, att_name, /global_scope)
      n = 0
   ENDIF ELSE n = nes(in)+1
   find = 0
   FOR i = 0,n-1 DO BEGIN 
      cdf_attget, id, att_name, i, alabel
      IF (alabel EQ label(1)) THEN find = 1
   ENDFOR 
   IF (find EQ 0 OR keyword_set(force)) THEN BEGIN 
      cdf_attput, id, att_name, n, label(0)
      cdf_attput, id, att_name, n+1, label(1)
      IF keyword_set(log) THEN BEGIN
         write_edit_data, date, log, label(0)
         write_edit_data, date, log, label(1)
      ENDIF 
   ENDIF 

   return
END
