PRO write_validb, date_in, validb, time_validb, file
;
;   Extract the validb flags for a day
;
;
   id = cdf_open(file)
   cdf_control, id, variable='BLOCK_MODE', get_var_info=bmi
   max_block = bmi.maxrec
   cdf_varget, id, 'BLOCK_MODE', block_mode, rec_count=max_block
   cdf_varget, id, 'BLOCK_TIME', block_time, rec_count=max_block

   time = dblarr(max_block)
   FOR i=0,max_block-1 DO BEGIN 
      cdf_epoch, block_time(i), y, m, d, h, m, s, milli, /breakdown_epoch
      time(i) = (h*60.d0+m)*60.d0+s+0.001d0*milli
   ENDFOR

   validb = bytarr(96,max_block)

   cdf_varget, id, 'BLOCK_STATUS', block_status, rec_count=max_block
   s = where(block_status NE 0)
   ns = n_elements(s)
   FOR i=0,ns-1 DO BEGIN
      IF (i EQ ns-1) THEN smax = max_block-1 ELSE smax = s(i+1)
      smin = s(i)
      cdf_varget, id, 'NAME_SUFFIX', name, rec_start=smin
      name = 'VALIDB'+string(name)

      cdf_varget, id, name, valid, rec_start=smin, rec_count=smax-smin+1
      validb(*,smin:smax) = valid      
   ENDFOR 

   cdf_close, id

   valid = bytarr(8,96,max_block)
   c = byte(2^indgen(8))
   FOR i=0,7 DO BEGIN
      valid(i,*,*) = (validb AND c(i)) EQ c(i)
   ENDFOR 
   np = 8*96*max_block
   validb = reform(valid, np)

   time_validb = dblarr(np)
   hpm = (13.8/768.d0)
   tb = findgen(768)*hpm
   FOR i=long(0),max_block-1 DO BEGIN
      ib1 = 768*i
      ib2 = 768*(i+1)-1
      time_validb(ib1:ib2) = tb+time(i)
   ENDFOR 

   IF keyword_set(stop) THEN stop
   return
END
