PRO write_validb_56, date_in, validb, time_validb, label, file, $
                     stop=stop, verbose=verbose, log=log
;
;   Write the validb flags for a time period
;
;
   pack_validb_56, validb, time_validb, validb_p56, time_p56

   id = cdf_open(file)
   cdf_control, id, variable='BLOCK_MODE', get_var_info=bmi
   max_block = bmi.maxrec
   cdf_varget, id, 'BLOCK_MODE', block_mode, rec_count=max_block
   cdf_varget, id, 'BLOCK_TIME', block_time, rec_count=max_block

   time = dblarr(max_block)
   FOR i=0,max_block-1 DO BEGIN 
      cdf_epoch, block_time(i), y, m, d, h, m, s, milli, /breakdown_epoch
      time(i) = (h*60.d0+m)*60.d0+s+0.001d0*milli
   ENDFOR

   rmin = (where(time EQ time_p56(0)))(0)
   rmax = (where(time EQ time_p56(n_elements(time_p56)-1)))(0)

   IF keyword_set(verbose) THEN BEGIN 
      print, rmin, rmax, rmax-rmin+1
      print, 'Time: ', time_p56
      print, 'Time: ', time(rmin:rmax)
      print, 'Validb: ', validb_p56(*)
   ENDIF 

   validb = bytarr(96,max_block)
   validb(*,rmin:rmax) = validb_p56

   cdf_varget, id, 'BLOCK_STATUS', block_status, rec_count=max_block
   s = where(block_status AND 2)
   ns = n_elements(s)
   FOR i=0,ns-1 DO BEGIN
      IF (i EQ ns-1) THEN smax = max_block-1 ELSE smax = s(i+1)
      smin = s(i)
      cdf_varget, id, 'NAME_SUFFIX', name, rec_start=smin
      name = 'VALIDB'+string(name)

      CASE (smin LE rmin) OF
         0: BEGIN
            CASE (smin LE rmax) OF 
               0: rc = 0
               1: BEGIN
                  CASE (smax LE rmax) OF 
                     0: BEGIN
                        rs = 0
                        rc = rmax-smin+1 ; Case V
                     END 
                     1: BEGIN
                        rs = 0
                        rc = smax-smin+1 ; Case IV
                     END 
                  ENDCASE
               END 
            ENDCASE 
         END 
         1: BEGIN
            CASE (smax LT rmin) OF 
               0: BEGIN
                  CASE (smax LE rmax) OF 
                     0: BEGIN
                        rs = rmin-smin
                        rc = rmax-rmin+1 ; Case III
                     END 
                     1: BEGIN
                        rs = rmin-smin
                        rc = smax-rmin+1 ; Case II
                     END 
                  ENDCASE
               END 
               1: rc = 0        ; Case I
            ENDCASE 
         END 
      ENDCASE 
      IF rc NE 0 THEN BEGIN 
         r1 = smin+rs
         r2 = r1+rc-1
         valid = validb(*,r1:r2)
         cdf_varput, id, name, valid, rec_start=rs
      ENDIF 
   ENDFOR 

   att_name = 'ValidB_Edits'
   write_global_att, id, att_name, label, log=log, date_in

   cdf_close, id

   IF keyword_set(stop) THEN stop
   return
END
