PRO write_validb_8, date_in, validb, time_validb, label, file, $
                     stop=stop, verbose=verbose, log=log
;
;   Write the validb flags for a time period
;
;
   pack_validb_8, validb, time_validb, validb_p8, time_p8

   id = cdf_open(file)
   cdf_control, id, variable='B_HIGH_TIME', get_var_info=bmi
   max_mjf = bmi.maxrec
   cdf_varget, id, 'B_HIGH_TIME', time, rec_count=max_mjf

   rmin = (where(time EQ time_p8(0)))(0)
   rmax = (where(time EQ time_p8(n_elements(time_p8)-1)))(0)
   nr = rmax-rmin+1

   IF keyword_set(verbose) THEN BEGIN 
      print, rmin, rmax, rmax-rmin+1
      print, 'Time: ', time_p8
      print, 'Time: ', time(rmin:rmax)
      print, 'Validb: ', validb_p8
   ENDIF 

   rs = rmin
   cdf_varput, id, 'B_HIGH_VALID', validb_p8, rec_start=rs

   att_name = 'ValidB_Edits'
   write_global_att, id, att_name, label, log=log, date_in

   cdf_close, id

   IF keyword_set(stop) THEN stop
   return
END
