PRO year_month_day, year, doy_in, month, day, verbose=verbose, stop=stop
;
;
;  Calculate year, month, day given the day of the year and year.
;  Also works for doy > 366.
;
;
;  $Log: year_month_day.pro,v $
;  Revision 1.4  1999/06/15 18:13:10  rdh
;  Updated to use hyd_day_of_year.
;
;  Revision 1.3  1998/03/10 20:19:33  rdh
;  Fixed bug for doy > 366.
;
;  Revision 1.2  1998/03/10 18:24:55  rdh
;  Added coding for doy > 366.
;
;
;
   n = n_params()

   IF (n EQ 0) THEN BEGIN
      print, "USAGE: PRO year_month_day, year_in_out, doy_in, "+$
       "month_out, day_out [,/stop][,/verbose]"
      stop
   ENDIF ELSE BEGIN
      IF (n NE 4) THEN BEGIN 
         print, 'ERROR in year_month_day: Need 4 arguments.'
         stop
      ENDIF
   ENDELSE
   IF (year LT 90) THEN BEGIN
      year = year+2000
   ENDIF ELSE BEGIN
      IF (year LT 100) THEN BEGIN
         year = year + 1900
      ENDIF
   ENDELSE

   doy = doy_in

   WHILE (doy GT hyd_day_of_year(year,12,31)) DO BEGIN
      doy = doy - hyd_day_of_year(year,12,31)
      year = year+1
   ENDWHILE

   
   month_length = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 31]

   IF (year MOD 4) EQ 0 THEN BEGIN 
      IF (year MOD 400 EQ 0) THEN BEGIN 
         month_length(1) = 29
      ENDIF ELSE BEGIN
         IF (year MOD 100 EQ 0) THEN $
          month_length(1) = 28 $
         ELSE $
          month_length(1) = 29 
      ENDELSE
   ENDIF

   day = doy
   month = 1
   i = 1
   while (day GT month_length(i-1)) DO BEGIN 
      day = day - month_length(i-1)
      i = i + 1
      month = i
      IF keyword_set(verbose) THEN print, '******** ', doy, year, month, day
   ENDWHILE 
   if (month GT 13) THEN BEGIN 
      month = 0
      day = 0
   ENDIF else BEGIN
      if (month EQ 13) THEN BEGIN 
         month = 1
         year = year + 1
      ENDIF
   ENDELSE 

   IF keyword_set(stop) THEN stop
   return
END




