pro check_back_ib, fix_proxy=fix_proxy, fix_points=fix_points
;
;   Check proxy files for background times
;
point_dir='/opt/hydra/gains_tmp/interbox/trigrid_data/points/'
proxy_dir='/opt/hydra/gains_tmp/interbox/proxy/'
dates=['19960529','19960530','19960531',$
       '19960601','19960602','19960603','19960604']
doy96=150+indgen(7)

glint_dir='/opt/hydra/extra_glint_data/'
for i=0,n_elements(dates)-1 do begin
    print, 'Reading Background for '+dates[i]

    gid=cdf_open(glint_dir+dates[i]+'_hyd_gm_v5.20.cdf')
    hyd_cdf_varget, gid, 'PENET_TIME', ptime
    hyd_cdf_varget, gid, 'PENET_BACK_ELE', back_ele
    cdf_close, gid

    r=where(ptime gt 0)
    ptime=ptime[r]
    back_ele=back_ele[r,*]

    if keyword_set(use_ddcal) then begin
        ddcal_dir='/opt/hydra/l1_14/'    
        gid=cdf_open(ddcal_dir+dates[i]+'_hyd_ddcal_v7.63.cdf')
        hyd_cdf_varget, gid, 'BLOCK_TIME_SSM', time_ddcal, rec_count=6272
        hyd_cdf_varget, gid, 'BACK_ELE', back_ddcal, rec_count=6272
        cdf_close, gid
    endif

    print, 'Reading Proxy Block Numbers for '+dates[i]
    f=findfile(proxy_dir+dates[i]+'/'+dates[i]+'*.idlsav', count=nf)

    block=intarr(nf)
    for j=0,nf-1 do block[j]=(str_sep(basename(f[j],suffix='.idlsav'),'_'))(2)
;
;   Sync up time to block number
;
    hyd_access, ttags, 'm3_iblock', m3_block, get_timetags=doy96[i]+[0,0.1]
    hyd_access, ttags, 'm3_time', m3_time

    block1=m3_block[0]
    time1=m3_time[0]

    proxy_time=(block-block1)*13.8+time1

    print, 'Checking Background for '+dates[i]

    nb=0
    nbd=0
    for j=0,n_elements(proxy_time)-1 do begin
        r=where(abs(ptime-proxy_time[j]) lt 0.002, nr)
        if keyword_set(use_ddcal) then begin
            rd=where(abs(time_ddcal-proxy_time[j]) lt 0.002, nrd)
        endif
        if nr ne 0 then begin
            max=max(back_ele[r(0),*])
            if max gt 0.1 then begin
                ;print, dates[i], j, ptime[r[0]], max
                nb=nb+1
                if keyword_set(use_ddcal) then begin
                    if nrd eq 0 or $
                      abs(max-max(back_ddcal[*,rd[0]])) gt 0.1 then stop
                endif
                if keyword_set(fix_proxy) then begin
                    proxy_file=f[j]
                    new_proxy_file=f[j]+'.back'
                    command='mv '+proxy_file+' '+new_proxy_file
                    spawn, command
                endif
                if keyword_set(fix_points) then begin
                    point_file=point_dir+dates[i]+'/'+dates[i]+$
                      '_points_'+string(block[j],format='(i4.4)')+'.idlsav'
                    new_point_file=point_file+'.back'
                    command='mv '+point_file+' '+new_point_file
                    spawn, command
                endif
            endif
        endif
    endfor
    print, n_elements(proxy_time), nb



endfor



end
