pro create_bracket_file, date
;+
; NAME:
;      create_bracket_file
; PURPOSE:
;      Create a blank 2/Sweep bracket file for a given date.
; CATEGORY:
;      2 Sweep
; CALLING SEQUENCE:
;      create_bracket_file, DateYYYYMMDD
; INPUTS:
;      Date: YYYYMMDD
; SIDE EFFECTS:
;      Creates file.
; RESTRICTIONS:
;      None.
; PROCEDURE:
;      Creates blank bracket and saves it.
; EXAMPLE:
;      create_bracket_file, 20010312
; MODIFICATION HISTORY:
;      Curator: rdh
;-  
  bracket_dir='/opt/hydra/2sweep_uperp/bracket/'
  bracket_file=bracket_dir+strtrim(date,2)+'_brackets.idlsav'
  lockfile=bracket_file+'.lock'
  status=idl_lockfile(lockfile, wait=30)
  if status eq 0 then begin
      hyd_file_status, bracket_file, exist=exist
      if exist ne 0 then begin
          message, 'bracket file created by another process.', /cont
          return
      endif
      message, 'creating new bracket file for '+date, /cont
      message, 'using 19960529 as a template', /cont

      restore, '/opt/hydra/2sweep_uperp/bracket/19960529_brackets.idlsav', $
        /verb
      brackets= brackets[0]
      brackets[0].iblock= -1
      brackets[0].isub= -1
  
      save, file='/opt/hydra/2sweep_uperp/bracket/'+strtrim(date,2)+ $
        '_brackets.idlsav', brackets
      status=idl_lockfile(lockfile, /rm)
  endif else begin
      message, 'Lockfile not acquired for bracket file creation.'
  endelse
end

