pro compare_values,time_s,val1,val2,var_label,title_str,pos_arr,time_range, $
                   pc_err_lim=pc_err_lim

y_title_arr=[var_label+', (old, new)','!7D!X'+var_label, '% !7D!X'+var_label]

num_plots=3
!p.charsize=2.0
set_page,nh=1,nv=num_plots

val_range=lin_bracket([val1,val2])
min_val=min([val1,val2])
max_val=max([val1,val2])

if (max_val le 0.) then val_range=[val_range(0),0.]
if (min_val ge 0.) then val_range=[0.,val_range(1)]

dif_val=abs(val2-val1)
a_pos=where(dif_val gt 0.,pos_count)
a_zero=where(dif_val eq 0.,zero_count)

if (pos_count ne 0) then begin
    dif_range=log_bracket(dif_val(a_pos))
;    if (zero_count ne 0) then begin
;        dif_val(a_zero)=dif_range(0)/10.
;        dif_range(0)=dif_range(0)/10.
;    endif 
endif else begin
    stop,'No data'
    dif_val(*)=1.e-4
    dif_range=[1.e-5,1.e-3]
endelse

a_pos_pc=where(dif_val ne 0. and val1 ne 0.,pos_pc_count)
a_nval_pc=where(dif_val eq 0. or val1 eq 0.,nval_pc_count)

dif_val_pc=dif_val

if (pos_pc_count ne 0) then begin
    dif_val_pc(a_pos_pc)=100*dif_val(a_pos_pc)/abs(val1(a_pos_pc))
    dif_pc_range=log_bracket(dif_val_pc(a_pos_pc))
    if (nval_pc_count ne 0) then begin
        dif_val_pc(a_nval_pc)=dif_pc_range(0)/10.
    endif
endif else begin
    dif_pc_range=[1.e-5,1.e-3]
    dif_val_pc(*)=1.e-4
endelse
if (zero_count ne 0) then begin
    dif_val(a_zero)=dif_range(0)/100.0
endif

plot_num=0

plot,[1],[1],xtitle='time, hr',ytitle=y_title_arr(plot_num), $
  position=pos_arr(*,plot_num),xtickformat='tick_hms',xstyle=1,$
  yrange=val_range
oplot,time_s,val1,thick=2,psym=1
oplot,time_s,val2,color=get_color_index('orange'),psym=1
plot_num=plot_num+1

tickname_arr=!x.tickname
tickname_arr(*)='   '

plot,[0],[0],ytitle=y_title_arr(plot_num),position=pos_arr(*,plot_num), $
  xstyle=1,xtickname=tickname_arr,yrange=dif_range,/ylog
oplot,time_s,dif_val
plot_num=plot_num+1

plot,[0],[0],ytitle=y_title_arr(plot_num),position=pos_arr(*,plot_num), $
  xstyle=1,xtickname=tickname_arr,title=title_str,yrange=dif_pc_range,/ylog
oplot,time_s,dif_val_pc,psym=-1

if (keyword_set(pc_err_lim)) then begin
    a_err=where(dif_val_pc ge pc_err_lim,errcount)
    if (errcount ne 0) then begin
        print,'Error times:  ',time_s(a_err)
        print,'Values,1:  ',val1(a_err)
        print,'Values,2:  ',val2(a_err)
        print,'Dif vals:  ',dif_val(a_err)
        print,'Prct dif:  ',dif_val_pc(a_err)
        print,'Time hms:  ',time_ssm_2_str(time_s(a_err))
        print,'Appx blk:  ',time_ssm_2_block(time_s(a_err))
        stop,'Here is the abberrant point.'
    endif else stop,'Abberrant point not found.'
endif

end








