function fill_sieve,data_array,positive=positive,indices=indices
;+
; NAME:  fill_sieve
;
;
;
; PURPOSE:  Return valid elements of a given array.
;
;
;
; CATEGORY:  
;
;
;
; CALLING SEQUENCE:
; valid_data=fill_sieve(input_array,positive=positive, $
;                                 indices=indices)
;
; 
; INPUTS:    input_array:    any numerical array
;
;
;
; OPTIONAL INPUTS:
;
;
;	
; KEYWORD PARAMETERS:     /positive:    array elements must be positive
; to be considered valid
;                         indices=indices:   original array indices of
;                         valid elements    
;
;
;
; OUTPUTS:   valid_data:   valid elements of original array
;
;
;
; OPTIONAL OUTPUTS:
;
;
;
; COMMON BLOCKS:
;
;
;
; SIDE EFFECTS:
;
;
;
; RESTRICTIONS:
;
;
;
; PROCEDURE:
;
;
;
; EXAMPLE:valid_data=fill_sieve(input_array,positive=positive, $
;                                 indices=indices)
;
;
;
; MODIFICATION HISTORY:
;
;-

@hd_include
if (keyword_set(positive)) then begin
    a=where(finite(data_array) ne 0 and data_array gt 0.0d0,acount)
    b=where(data_array eq 0.,zerocount)
    if (zerocount ne 0) then print,'Warning:  zeroes removed from data!!!'
endif else begin
    a=where(finite(data_array) ne 0 and data_array gt 10.*hd_fill,acount)
endelse

indices=a
if (acount ne 0) then begin
    data_out=data_array(a)
endif else begin
    data_out=[-1.e31]
endelse
return,data_out
end
