pro gen_fit_wrapper, x=x_in, sigma_x=sigx_in, $
                     y=y_in, sigma_y=sigy_in, $
                     guess_slope=guess_slope, $
                     slope=slope, intercept=intercept, $ 
                     chisq=chisq, rchisq=rchisq, $
                     s2=s2, $ 
                     c68=c68, c95=c95, c99=c99,$
                     ks_c68=ks_c68, ks_c95=ks_c95, ks_c99=ks_c99,$
                     status=status, $
                     wrap_verbose=wrap_verbose, $
                     wrap_status=wrap_status, $
                     kappa_data=kappa_data, $
                     _extra=e
;+
;
; Wrapper for gen_fit_release to normalize slopes to 1.0
;
;
;-
if keyword_set(guess_slope) then $
  message, 'gen_fit_wrapper not coded for guess_slope'

iter_max=10
wrap_status=0

n=n_elements(x_in)
xa=abs(total(x_in)/float(n))
ya=abs(total(y_in)/float(n))
if xa lt 1e-6 then ma=1.0 else ma=ya/xa
if ya lt 1e-6 then ma=1.0 

iter=0
slope=ma
repeat begin
    iter=iter+1
    ma=slope
    if keyword_set(wrap_verbose) then print, 'Normalizing slope = ', ma

    x=x_in
    y=y_in/ma
    sigx=sigx_in
    sigy=sigy_in/ma

    gen_fit_release, $
      x=x,sigma_x=sigx,y=y,sigma_y=sigy, $
      slope=slope, intercept=intercept, $ 
      chisq=chisq, rchisq=rchisq, $
      s2=s2, $ 
      status=status, $
      c68=c68, c95=c95, c99=c99,$
      ks_c68=ks_c68, ks_c95=ks_c95, ks_c99=ks_c99,$
      kappa_data=kappa_data, $
      _extra=e
    
    if status ne 1 and status ne 4 then begin
        message, 'gen_fit_release status failed.', /cont
        return
    endif

    if keyword_set(wrap_verbose) then begin
        print, 'Normalizing slope = ', ma
        print, 'intermediate slope, intercept=', slope, intercept
        print, 'intermediate ks_c68=', ks_c68
    endif
    islope=slope
    
    c68=c68*ma
    c95=c95*ma
    c99=c99*ma
    
    ks_c68=ks_c68*ma
    ks_c95=ks_c95*ma
    ks_c99=ks_c99*ma
    
    slope=slope*ma
    kappa_data.f1=ma*kappa_data.f1
    kappa_data.kappa=kappa_data.kappa/float(n-2)

endrep until (islope lt sqrt(3.0) and islope gt 1.0/sqrt(3.0)) or $
  (iter eq iter_max)

if iter eq iter_max then status=iter_max

end




