pro hyd_walen, date, time_start_ssm, time_stop_ssm, ele=ele, ion=ion, $
               two_swp=two_swp,m3=m3,return_code,$
       norm_chi_sq, fit_slope, error_slope_68, expected_slope, error_expected,$
       dynamic_range_e, x_mean_e_kms, x_err_e_kms, y_mean_e_kms, y_err_e_kms, $
       b_2sw, sig_b,moment_set=moment_set,ps=ps,output_dir=output_dir, $
               plot_inputs=plot_inputs
rfill=-1.0e31
dynamic_range=fltarr(2)+rfill ; the width of data points in x and y space
error_expected=fltarr(2)+rfill ; errors extremes of slope from unity
expected_slope=rfill           ; target slope, usually 1
error_slope_68=fltarr(2)+rfill; generally asymmetric output of gen_fit_release
fit_slope=rfill; returned value from gen_fit
norm_chi_sq=rfill ; best fit chisq
return_code=rfill
;
;
;
fuzz_2sw=4.6/2 ; sec
fuzz_m3=13.8/2.  ; sec
fuzz_hrkp=1.15/2 ; sec

if (size(time_start_ssm,/type) eq 7) then begin
    time_start_ssm=time_str_2_ssm(time_start_ssm)
endif
if (size(time_stop_ssm,/type) eq 7) then begin
    time_stop_ssm=time_str_2_ssm(time_stop_ssm)
endif

if (keyword_set(ion)) then begin
    species='ion'
endif else if (keyword_set(ele)) then begin
    species='ele'
endif else begin
    species='ele'
endelse

if (keyword_set(two_swp)) then begin
    moment_set='two_swp'
endif
if (keyword_set(m3)) then begin
    moment_set='m3'
endif
if (keyword_set(two_swp) and keyword_set(m3)) then begin
    print,'Defaulting to M3!'
endif

if(keyword_set(ele) or keyword_set(ion)) then begin

     ; take a time interval input for either species
     ; go get via hyd_access_ez the required input data:
     ; formulate the input quantities:
     ;  all vector quantities in payload
     ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; center times date,    time_ssm(*)
     ;  need two sweep electron flows, ion flows padded to this time resolution: ue_2sw(*,3)
     ;  vector B averaged to two sweep resolution                                 b_2sw(*,3)  averages as stored in scanner
     ;  two sweep electron density                                            den_e_2sw(*)
     ;  two sweep electron Pparl Pperp and that of the Ions from M3         pparl_e_2sw(*)
     ;                                                                      pperp_e_2sw(*)
     ;                    
     ;                   
     ;                                                                      pparl_i_2sw(*)  replicated M3 value
     ;                                                                      pperp_i_2sw(*)     ditto
     ;                        54 hz   std dev to the two sweep intervals          sig_b(*,3)
     ;                        errors on flow from scanner                  delta_Ue_2sw(*,3)
     ;                    statistical fraction error density each reading =statistical_fraction_data(*)
     ;                    statistical fraction via time from one sweep vs reading = fractional_var_during_two_sweep(*)
     ;;;NB ;;;;;;; all data need to be screened from this list if they are fill and the corresponding
     ;;;;;;;;;;;; entries of the other variables
     ;                     one sweep estimate of ne and Te for each data point considered
     ;                                                                     
     ;                
     ; 
     ;
     ;  compute statistical esitmate of fraction density due Poisson rates via Dave's formula
     ;               using 
     ; all data culled for fill.......
     ;call_two_sweep_reads, n_valid_pts, statistical_fraction_error_density, fractional_var_during_two_sweep,$
     ;     date, time_start_ssm, time_stop_ssm, ele=ele, ion=ion, date(*), time_ssm(*), ue_2sw(*,3) [km/s], delta_Ue_2sw(*,3) [km/s],$
     ;     b_2sw(*,3)[nT], den_e_2sw(*)[/cc], pparl_e_2sw(*)[ergs/cc], pperp_e_2sw(*)[ergs/cc], pparl_i_2s[ergs/cc, padded M3],$
     ;     pperp_i_2s[ergs/cc, padded M3], sig_b(*,3)[std deviation nT over 2sw], statistical_fraction_data(*),$
     ;     fractional_var_during_two_sweep(*)
     ; [NB:] last two quantities are derived quanties respectively from subroutine Dave wrote for Poisson errors, that can
     ;   easily provide fractional error = Poisson Est Error/Mean Den as first variable; second variable is the dispersion
     ;   about the mean 2sw average in evidence by the 1 sweep estimates =( Sigma (one Sweep - 2sweep)^2/(2-1))^0.5 
     ;   that are easily manufactured in the reader.
     ; [NB: II] the subsequent code presumes that all data with asterisk are time synchronous, and that there are NO FILL, NAN's
     ;   or other objectionable stuff in the output strings returned for consideration below.
     ; [NB: III] n_valid_points= are the number of data points being returned......  
;    moment_set='two_swp'
    
;;;   Data read subroutine inserted here:::::\\
;    species='ele'
;    moment_set='two_swp'

    retrieve_data,date=date,start_time_ssm=time_start_ssm, $
      end_time_ssm=time_stop_ssm,species=species, $
      moment_set=moment_set,time_ele,dens_ele,den_sig_ele,u_ele, $
      u_sig_ele,t_ele,p_prp_ele_ele,p_prl_ele_ele,p_prp_ion_ele, $
      p_prl_ion_ele,b_field_ele,b_field_sig_ele,n_valid_ele, $
      timetags=timetags,retrieve_status=retrieve_status

    if (retrieve_status ne 1) then begin
        
        return_code=-2
        return
    endif

;    moment_set='m3'
;    retrieve_data,date=date,start_time_ssm=time_start_ssm, $
;      end_time_ssm=time_stop_ssm,species=species, $
;      moment_set=moment_set,time_ele,dens_ele,den_sig_ele,u_ele, $
;      u_sig_ele,t_ele,p_prp_ele_ele,p_prl_ele_ele,p_prp_ion_ele, $
;      p_prl_ion_ele,b_field_ele,b_field_sig_ele,n_valid_ele, $
;      timetags=timetags

;    moment_set='m3'
;    retrieve_data,date=date,start_time_ssm=time_start_ssm, $
;      end_time_ssm=time_stop_ssm,species='ele', $
;      moment_set=moment_set,time_ele_m,dens_ele_m,den_sig_ele_m,u_ele_m, $
;      u_sig_ele_m,t_ele_m,p_prp_ele_ele_m,p_prl_ele_ele_m,p_prp_ion_ele_m, $
;      p_prl_ion_ele_m,b_field_ele_m,b_field_sig_ele_m,n_valid_ele_m, $
;      timetags=timetags_m

    if (keyword_set(plot_inputs)) then begin
        if (keyword_set(ps)) then begin
            filename='inputs_'+strtrim(date,2)+'_'+ $
              time_ssm_2_str_0(time_start_ssm)+'_'+ $
              time_ssm_2_str_0(time_stop_ssm)+'_'+moment_set+ $
              '_'+species+'.ps'
            if (keyword_set(output_dir)) then $
              filename=output_dir+filename
            set_ps,file=filename
            plot_title='Inputs '+strtrim(date,2)+' '+ $
              time_ssm_2_str_0(time_start_ssm)+' '+ $
              time_ssm_2_str_0(time_stop_ssm)+' '+moment_set+ $
              ' '+species
        endif

        plot_title='Inputs '+strtrim(date,2)+' '+ $
          time_ssm_2_str_0(time_start_ssm)+' '+ $
          time_ssm_2_str_0(time_stop_ssm)+' '+moment_set+ $
          ' '+species
        
        set_page,nh=1,nv=2
        plot,time_ele,dens_ele,ytitle='n!De!N, cm!U-3!N',$
          title=plot_title,xtickformat='tick_hms_round',charsize=1.2
        plot,time_ele,den_sig_ele,ytitle='!7r!X!Dn!De!N!N, cm!U-3!N', $
          xtitle='Time, s',charsize=1.2,xtickformat='tick_hms_round'
        if (not keyword_set(ps)) then stop

        set_page,nh=1,nv=6
        plot,time_ele,u_ele(*,0),ytitle='u!Dx!N, km/s',charsize=1.8, $
          title=plot_title,xtickformat='tick_hms_round'
        plot,time_ele,u_ele(*,1),ytitle='u!Dy!N, km/s',charsize=1.8, $
          xtickformat='tick_hms_round'
        plot,time_ele,u_ele(*,2),ytitle='u!Dz!N, km/s',charsize=1.8, $
          xtickformat='tick_hms_round'
        plot,time_ele,u_sig_ele(*,0),ytitle='!7r!X!Du!Dx!N!N, cm!U-3!N', $
          charsize=1.8,xtickformat='tick_hms_round'
        plot,time_ele,u_sig_ele(*,1),ytitle='!7r!X!Du!Dy!N!N, cm!U-3!N', $
          charsize=1.8,xtickformat='tick_hms_round'
        plot,time_ele,u_sig_ele(*,2),xtitle='Time, s', $
          xtickformat='tick_hms_round',$
          ytitle='!7r!X!Du!Dx!N!N, cm!U-3!N',charsize=1.8
        if (not keyword_set(ps)) then stop
        
        set_page,nh=1,nv=4
        plot,time_ele,p_prp_ele_ele,ytitle='P!D!9x!X,e!N, dynes/cm!U2!N', $
          charsize=1.8,title=plot_title,xtickformat='tick_hms_round'
        plot,time_ele,p_prl_ele_ele,ytitle='P!D!9#!X,e!N, dynes/cm!U2!N', $
          charsize=1.8,xtickformat='tick_hms_round'
        plot,time_ele,p_prp_ion_ele,ytitle='P!D!9x!X,i!N, dynes/cm!U2!N', $
          charsize=1.8,xtickformat='tick_hms_round'
        plot,time_ele,p_prl_ion_ele,xtitle='Time, s', $
          xtickformat='tick_hms_round', $
          ytitle='P!D!9#!X,i!N, dynes/cm!U2!N', charsize=1.8
        if (not keyword_set(ps)) then stop

        set_page,nh=1,nv=6
        plot,time_ele,b_field_ele(*,0),ytitle='B!Dx!N, nT',charsize=1.8, $
          title=plot_title,xtickformat='tick_hms_round'
        plot,time_ele,b_field_ele(*,1),ytitle='B!Dy!N, nT',charsize=1.8, $
          xtickformat='tick_hms_round'
        plot,time_ele,b_field_ele(*,2),ytitle='B!Dz!N, nT',charsize=1.8, $
          xtickformat='tick_hms_round'
        plot,time_ele,b_field_sig_ele(*,0),ytitle='!7r!X!DB!Dx!N!N, nT', $
          charsize=1.8,xtickformat='tick_hms_round'
        plot,time_ele,b_field_sig_ele(*,1),ytitle='!7r!X!DB!Dy!N!N, nT', $
          charsize=1.8,xtickformat='tick_hms_round'
        plot,time_ele,b_field_sig_ele(*,2),xtitle='Time, s', $
          title='!7r!X!DB!Dz!N!N, nT',charsize=1.8, $
          xtickformat='tick_hms_round'
        if (not keyword_set(ps)) then stop
        if (keyword_set(ps)) then end_of_prog

    endif
    
;    retrieve_data,date=date,start_time_ssm=time_start_ssm, $
;      end_time_ssm=time_stop_ssm,species='ion', $
;      moment_set='two_swp',time_ion,dens_ion,den_sig_ion,u_ion, $
;      u_sig_ion,t_ion,p_prp_ele_ion,p_prl_ele_ion,p_prp_ion_ion, $
;      p_prl_ion_ion,b_field_ion,b_field_sig_ion,n_valid_ion

;    old_test = 1
;    den_sig_ele_0=den_sig_ele
;    if (keyword_set(old_test)) then begin
;        restore,'test_new_two_swp.idlsav'
;        restore,'m3_test_input_for_wtest.idlsav',/verbose
;        help,dens_ele
;        help,den_sig_ele
;        help,u_ele
;        help,u_sig_ele
;        help,t_ele
;        help,p_prp_ele_ele
;        help,p_prp_ion_ele
;        help,p_prl_ele_ele
;        help,p_prl_ion_ele
;        help,b_field_ele
;        help,b_field_sig_ele
;        print,n_valid_ele
;        stop
;        plot,dens_ele,den_e_2sw
;        stop
;        plot,den_sig_ele_0,den_sig_ele
;        stop
;        plot,u_ele(*,0),ue_2sw(*,0)
;        stop
;        plot,u_ele(*,1),ue_2sw(*,1)
;        stop
;        plot,u_ele(*,2),ue_2sw(*,2)
;        stop
;        plot,u_sig_ele(*,0),delta_ue_2sw(*,0)
;        stop
;        plot,u_sig_ele(*,1),delta_ue_2sw(*,1)
;        stop
;        plot,u_sig_ele(*,2),delta_ue_2sw(*,2)
;        stop
;        plot,p_prp_ele_ele,pperp_ele
;        stop
;        plot,p_prl_ele_ele,pparl_ele
;        stop
;        plot,p_prp_ion_ele,pperp_ion
;        stop
;        plot,p_prl_ion_ele,pparl_ion
;        stop
;        plot,b_field_ele(*,0),b_2sw(*,0)
;        stop
;        plot,b_field_ele(*,1),b_2sw(*,1)
;        stop
;        plot,b_field_ele(*,2),b_2sw(*,2)
;        stop
;        plot,b_field_sig_ele(*,0),sig_b(*,0)
;        stop
;        plot,b_field_sig_ele(*,1),sig_b(*,1)
;        stop
;        plot,b_field_sig_ele(*,2),sig_b(*,2)
;        stop

;        den_sig_ele=den_sig_ele_0

;        dens_ele=data.density_ele
;        den_sig_ele=data.dn_ele/data.density_ele
;        u_ele=(transpose(data.u_pay_ele))(*,0:2)
;        u_sig_ele=(transpose(u_ele_sigmas))(*,0:2)
;        p_prp_ele_ele=data.pres_perp_ele
;        p_prp_ion_ele=data.pres_perp_ion
;        p_prl_ele_ele=data.pres_parl_ele
;        p_prl_ion_ele=data.pres_parl_ion
;        
;        b_field_ele=(transpose(data.b_block_avg_pay))(*,0:2)
;        b_field_sig_ele=(transpose(data.b_block_avg_sig))(*,0:2)
;        
;        n_valid_ele=n_elements(data)
;        
;    endif

;    print,den_e_2sw
;    print,ue_2sw(*,0)
;    print,ue_2sw(*,1)
;    print,ue_2sw(*,2)
;    print,b_2sw(*,0)
;    print,b_2sw(*,1)
;    print,b_2sw(*,2)
;    print,delta_ue_2sw(*,0)
;    print,delta_ue_2sw(*,1)
;    print,delta_ue_2sw

;    stop

;    help,u_ele
;    help,dens_ele
;    help,b_field_ele
;    help,u_sig_ele
;    help,b_field_sig_ele
;    stop
 
;;;  For 2 swp ele
;    in_index=where(abs(u_ele(*,0)) lt 1.e7,incount)
;    in_index=lindgen(n_valid_ele)

;    ue_2sw=u_ele(in_index,*)
;    den_e_2sw=dens_ele(in_index)
;    b_2sw=b_field_ele(in_index,*)
;    delta_ue_2sw=u_sig_ele(in_index,*)
;    n_valid_pts=n_valid_ele
;    n_valid_pts=incount
;    sig_b=b_field_sig_ele(in_index,*)
;    pparl_ion=p_prl_ion_ele(in_index)
;    pperp_ion=p_prp_ion_ele(in_index)
;    pparl_ele=p_prl_ele_ele(in_index)
;    pperp_ele=p_prp_ele_ele(in_index)
 
;    n_valid_pts=n_elements(den_e_2sw)
   
;    set_page,nh=2,nv=2
;    plot,ue_2sw(*,0),b_2sw(*,0),psym=1
;    plot,ue_2sw(*,1),b_2sw(*,1),psym=1
;    plot,ue_2sw(*,2),b_2sw(*,2),psym=1
;    stop

    den_e_2sw=dens_ele
    ue_2sw=u_ele
    b_2sw=b_field_ele
    delta_ue_2sw=u_sig_ele
    sig_b=b_field_sig_ele
    pparl_ion=p_prl_ion_ele
    pperp_ion=p_prp_ion_ele
    pparl_ele=p_prl_ele_ele
    pperp_ele=p_prp_ele_ele
    n_valid_pts=n_valid_ele
;   den_sig_ele is loaded with the correct name

;;specifications: hyd_access reads and minimal transformation to give derived output:                  
     ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
     if (n_valid_pts lt 3) then begin
         return_code=-1   ;Not enough data
         return                 
     endif
;   YOU NEED TWO READINGS IN THE INTERVAL to make a difference....
                                        ;   Two time intervals gives three differences one per component
                                        ;   Three give six  <---- minimal overdeterminancy......
                                        ;    etc ....
     ; all data across set are ok below here.......
     ;         compute expected alpha
     ;;;;;;;;;;;consider all permutations
     n=n_valid_pts
     ;make differences
     com_mass=1.6e-24+9.1e-28   ; cgs
     rhocm=com_mass*den_e_2sw    ; make this the same whether electrons or ions... ie from electrons.... den_e should always be used not ion
     delta_vx_e=fltarr(n^2)
     delta_vy_e=fltarr(n^2)
     delta_vz_e=fltarr(n^2)
     delta_bx_o_rho=fltarr(n^2)
     delta_by_o_rho=fltarr(n^2)
     delta_bz_o_rho=fltarr(n^2)
     error_vx_e=fltarr(n^2)
     error_vy_e=fltarr(n^2)
     error_vz_e=fltarr(n^2)
     error_bx_term=fltarr(n^2)
     error_by_term=fltarr(n^2)
     error_bz_term=fltarr(n^2)
     delta_bx_term=fltarr(n^2)
     delta_by_term=fltarr(n^2)
     delta_bz_term=fltarr(n^2)
     icounter=-1
     for jkl=0,n-2 do begin
       for ikl=jkl+1,n-1 do begin
        ;;;;;;;;;;;;;;;;;;;; form all needed differences::::::::::jkl-ikl
;        fractional_error_density_jkl= (statistical_fraction_error_density(jkl)^2 + fractional_var_during_two_sweep(jkl)^2)^0.5
;        fractional_error_density_ikl= (statistical_fraction_error_density(ikl)^2 + fractional_var_during_two_sweep(ikl)^2)^0.5
           
           fractional_error_density_jkl=den_sig_ele(jkl)
           fractional_error_density_ikl=den_sig_ele(ikl)
        nt2G=1.0e-5 
        icounter=icounter+1
        error_vx_e(icounter)=(delta_ue_2sw(jkl,0)^2+delta_ue_2sw(ikl,0)^2)^0.5  ;assumed km/s
        delta_vx_e(icounter)= (ue_2sw(jkl,0)-ue_2sw(ikl,0))                         
        error_vy_e(icounter)=(delta_ue_2sw(jkl,1)^2+delta_ue_2sw(ikl,1)^2)^0.5   ;assumed km/s
        delta_vy_e(icounter)= (ue_2sw(jkl,1)-ue_2sw(ikl,1))                     ;assumed km/s

        error_vz_e(icounter)=(delta_ue_2sw(jkl,2)^2+delta_ue_2sw(ikl,2)^2)^0.5  ;assumed km/s
        delta_vz_e(icounter)= (ue_2sw(jkl,2)-ue_2sw(ikl,2))                     ;assumed km/s

        error_bx_term(icounter)=  nt2G*( (b_2sw(jkl,0)/den_e_2sw(jkl)*fractional_error_density_jkl)^2 +  $
                                         (b_2sw(ikl,0)/den_e_2sw(ikl)*fractional_error_density_ikl)^2 +        $
                               (sig_b(jkl,0)/den_e_2sw(jkl))^2 + (sig_b(ikl,0)/den_e_2sw(ikl))^2)^0.5/com_mass

;        if (finite(error_bx_term(icounter) ne 1)) then stop

        delta_bx_term(icounter)=            nt2G*(b_2sw(jkl,0)/den_e_2sw(jkl)-b_2sw(ikl,0)/den_e_2sw(ikl)) /com_mass
        error_by_term(icounter)=  nt2G*( (b_2sw(jkl,1)/den_e_2sw(jkl)*fractional_error_density_jkl)^2 + $
                                         (b_2sw(ikl,1)/den_e_2sw(ikl)*fractional_error_density_ikl)^2 +       $
                               (sig_b(jkl,1)/den_e_2sw(jkl))^2 + (sig_b(ikl,1)/den_e_2sw(ikl))^2)^0.5/com_mass
        delta_by_term(icounter)=            nt2G*(b_2sw(jkl,1)/den_e_2sw(jkl)-b_2sw(ikl,1)/den_e_2sw(ikl))/com_mass 

;        if (finite(error_by_term(icounter) ne 1)) then stop

   
        error_bz_term(icounter)=  nt2G*( (b_2sw(jkl,2)/den_e_2sw(jkl)*fractional_error_density_jkl)^2 + $
                               (b_2sw(ikl,2)/den_e_2sw(ikl)*fractional_error_density_ikl)^2 +       $
                               (sig_b(jkl,2)/den_e_2sw(jkl))^2 + (sig_b(ikl,2)/den_e_2sw(ikl))^2)^0.5/com_mass

;        if (finite(error_bz_term(icounter) ne 1)) then stop


        delta_bz_term(icounter)=                 nt2G*(b_2sw(jkl,2)/den_e_2sw(jkl)-b_2sw(ikl,2)/den_e_2sw(ikl))/com_mass
       endfor  ; ikl
     endfor   ; jkl

;     print,error_bx_term
;     print,error_by_term
;     print,error_bz_term
;     stop

;     print,delta_vx_e
;     print,delta_vy_e
;     print,delta_vz_e
;     print,error_vx_e
;     print,error_vy_e
;     print,error_vz_e
;     stop

     ;
     ;;;TO BE DONE Thurs and Friday;;;;collapse arrays to (0:icounter) all of above......

     ;
     ;  Put [B/n] into Alfven i.e. (km/s) units
     ;
     ;  Notice that Pressure anisotropy only has to be known across the interval.
     ;  Only its average value and fractional variability across the entire time interval are used in the analysis.
     ;
     pparl=pparl_ion+pparl_ele ;in ergs/cm
     pperp=pperp_ion+pperp_ele ; in erg/cc
     alpha = 1.0e-5*(rhocm*(1.0d0/4.0d0/!pi - (pparl-pperp)/(1.0d-10*hd_magnitude(b_2sw)^2)))^0.5
     if (n_elements(alpha) eq 1) then begin
        alpha_avg=alpha(0)
        alpha_sig=0
     endif else begin
       slp_stats=moment(alpha)
       alpha_avg=slp_stats(0)
       alpha_sig=sqrt(slp_stats(1))
     endelse
     ;  Theoretically slope with fits below should have slope 1
     ;  Fractional Error is expect to be
     slope_theory=1
     slope_theory_sigma=alpha_sig/alpha_avg
     expected_slope=slope_theory
     error_expected=slope_theory_sigma
     ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
     ;
     ;      Target Slope is +/-1 + slope_theory_sig
     ;
     ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


     ;
     ;   calculate alpha uncertainty
     ;   if density calibrated correctly Gen_fit slope of delta_v_j vs delta_b_j_alfven should be unity
     ;            to within delta alpha/alpha


     delta_bx_alfven= alpha_avg*delta_bx_term  ;km/s
     delta_by_alfven= alpha_avg*delta_by_term  ;km/s
     delta_bz_alfven= alpha_avg*delta_bz_term  ;km/s
     error_bx_alfven= alpha_avg*error_bx_term  ;km/s
     error_by_alfven= alpha_avg*error_by_term  ;km/s
     error_bz_alfven= alpha_avg*error_bz_term  ;km/s

     ;
     ;  Ready for Gen_Fit_Release  x; slope no intercept; delta_b_j_alfven; y= delta_v_j of electrons
     ;

     x_mean_e_kms=[delta_bx_alfven(0:icounter),delta_by_alfven(0:icounter),delta_bz_alfven(0:icounter)]
     x_err_e_kms =[error_bx_alfven(0:icounter),error_by_alfven(0:icounter),error_bz_alfven(0:icounter)]
     y_mean_e_kms=[delta_vx_e(0:icounter),delta_vy_e(0:icounter),delta_vz_e(0:icounter)]
     y_err_e_kms =[error_vx_e(0:icounter),error_vy_e(0:icounter),error_vz_e(0:icounter)]

;     stop

     dynamic_range_e=[max(abs(x_mean_e_kms)), max(abs(y_mean_e_kms))]

;     plot,x_mean_e_kms,y_mean_e_kms,psym=1

;     print,x_mean_e_kms
;     a=where(finite(x_mean_e_kms) ne 1)
;     if (a(0) ne -1) then stop
;     print,x_err_e_kms
;     a=where(finite(x_err_e_kms) ne 1)
;     if (a(0) ne -1) then stop
;     print,y_mean_e_kms
;     a=where(finite(y_mean_e_kms) ne 1)
;     if (a(0) ne -1) then stop
;     print,y_err_e_kms
;     a=where(finite(y_err_e_kms) ne 1)
;     if (a(0) ne -1) then stop
;     old_fit_input=1
;     if (keyword_set(old_fit_input)) then begin 
;         restore,'m3_input_2_fit.idlsav',/verbose
;         set_page,nh=2,nv=4
;         x_mean_e_kms_0=x
;         y_mean_e_kms_0=y
;         x_err_e_kms_0=sigx
;         y_err_e_kms_0=sigy

;         a0=sort(-x_mean_e_kms_0)
;         a1=sort(x_mean_e_kms)
         
;         x_mean_e_kms_0_p=x_mean_e_kms_0(a0)
;         x_mean_e_kms_p=-x_mean_e_kms(a1)
;         y_mean_e_kms_0_p=y_mean_e_kms_0(a0)
;         y_mean_e_kms_p=-y_mean_e_kms(a1)
;         x_err_e_kms_0_p=x_err_e_kms_0(a0)
;         x_err_e_kms_p=x_err_e_kms(a1)
;         y_err_e_kms_0_p=y_err_e_kms_0(a0)
;         y_err_e_kms_p=y_err_e_kms(a1)
;         
;         set_page,nh=1,nv=4

;         plot,x_mean_e_kms_0_p,x_mean_e_kms_p,psym=3
;         plot,y_mean_e_kms_0_p,y_mean_e_kms_p,psym=3
;         plot,x_err_e_kms_0_p,x_err_e_kms_p,psym=3
;         plot,y_err_e_kms_0_p,y_err_e_kms_p,psym=3

;         stop
         
;     endif
     
     for i=0,0 do begin
         case i of
             0: begin                 
                 gen_fit_wrapper,x=x_mean_e_kms,sigma_x=x_err_e_kms, $
                   y=y_mean_e_kms, $
                   sigma_y=y_err_e_kms,slope=slope_e,nparms=1,c68=c68_e, $
                   ks_c68=ks_c68_e,status=status,/force_kappa_search, $
                   kappa_data=kappa_data_e,rchisq=rchisq_e,errorpercent=0.001
             end
             1:begin
                 x_mean_e_kms=x_mean_e_kms_0
                 y_mean_e_kms=y_mean_e_kms_0
                 x_err_e_kms=x_err_e_kms_0
                 y_err_e_kms=y_err_e_kms_0
                 gen_fit_wrapper,x=x_mean_e_kms,sigma_x=x_err_e_kms, $
                   y=y_mean_e_kms, $
                   sigma_y=y_err_e_kms,slope=slope_e,nparms=1,c68=c68_e, $
                   ks_c68=ks_c68_e,status=status,/force_kappa_search, $
                   kappa_data=kappa_data_e,rchisq=rchisq_e,errorpercent=0.001
             end
             2:begin
                 x_mean_e_kms=x_mean_e_kms_p
                 y_mean_e_kms=y_mean_e_kms_p
                 x_err_e_kms=x_err_e_kms_p
                 y_err_e_kms=y_err_e_kms_p

                 gen_fit_wrapper,x=x_mean_e_kms,sigma_x=x_err_e_kms, $
                   y=y_mean_e_kms, $
                   sigma_y=y_err_e_kms,slope=slope_e,nparms=1,c68=c68_e, $
                   ks_c68=ks_c68_e,status=status,/force_kappa_search, $
                   kappa_data=kappa_data_e,rchisq=rchisq_e,errorpercent=0.001
             end
             3:begin
                 x_mean_e_kms=x_mean_e_kms_0_p
                 y_mean_e_kms=y_mean_e_kms_0_p
                 x_err_e_kms=x_err_e_kms_0_p
                 y_err_e_kms=y_err_e_kms_0_p


                 gen_fit_wrapper,x=x_mean_e_kms,sigma_x=x_err_e_kms, $
                   y=y_mean_e_kms, $
                   sigma_y=y_err_e_kms,slope=slope_e,nparms=1,c68=c68_e, $
                   ks_c68=ks_c68_e,status=status,/force_kappa_search, $
                   kappa_data=kappa_data_e,rchisq=rchisq_e,errorpercent=0.001
             end
             else: print,'No way'
         endcase
         
;     plot,kappa_data_e.f1,kappa_data_e.kappa,/ylog
;     stop
         if (status ne 1) then begin
             case status of
                 0: print,'Cant find min of kappa'
                 1: print,'pass'
                 2: print,'kappa search failed'
                 3: print,'fail'
                 4: print, $
                   'pass for nparms = 0--doesnt apply here!!! This is a FAIL'
                 5: print,'Nonconvergence'
                 else: print,'huh?'
             endcase
             norm_chi_sq=-1.e31
             fit_slope=-1.e31
             error_slope_68=[-1.e31,-1.e31]
         endif else begin
             norm_chi_sq=rchisq_e
             fit_slope=slope_e
             error_slope_68=ks_c68_e
         endelse
         
         return_code=status
         
         
;     save,file='/home/ddm/walen_compare/new_walen_2swp_data.idlsav',$
;       x_mean_e_kms,x_err_e_kms,y_mean_e_kms,y_err_e_kms,status, $
;       kappa_data
;     stop
         
         if (keyword_set(ps)) then begin
             filename=species+'_'+moment_set+'_'+ $
               strtrim(date,2)+'_'+ $
               time_ssm_2_str_0(time_start_ssm)+'_'+ $
               time_ssm_2_str_0(time_stop_ssm)+ $
               '.ps'
             if (keyword_set(output_dir)) then begin
                 filename=output_dir+filename
             endif
             set_ps,file=filename,/color
         endif
         plot_walen_1,date,time_start_ssm,time_stop_ssm,kappa_data_e, $
           x_mean_e_kms,y_mean_e_kms,x_err_e_kms,y_err_e_kms, $
           ks_c68_e,slope_e,rchisq_e,species=species,slope_theory, $
           slope_theory_sigma,moment_set=moment_set,status=status
         if (keyword_set(ps)) then begin
             end_of_prog
         endif
;         endelse
     endfor
     
                                ;  wrapper to prescale for fit near slope 1
                                ;
                                ;  Ready for Gen_Fit_Release  x; slope no intercept; x_mean_kms+/-x_err_kms, y_mean_kms+/-y_err_kms
                                ;  of electrons
                                ;
                                ;
                                ;  Plot data points and then use error_flags.pro  from idl_common to put both errors x and
                                ;            y as overplot
     ;

     ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
     ;;;;;;; Patch into Pams Plotting information for shaded regions etc. TBD
     ; Specification: Plots should be by keyword.....

     ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
endif 
;;;;;;;;;;;;;;;;;ion branch
;;;; get m3 data for the same time interval and revise block average ion parms and
;;;; B vector with revised variances over 13.8 sec
;;;; need P_parl and P_perp electron and average density and variability over this
;;;; interval as well....... to determin  

    goto,finito
;;;  For 2 swp ion

    ui_2sw=u_ion
    den_e_2sw=dens_ion
    b_2sw=b_field_ion
    delta_ui_2sw=u_sig_ion
    n_valid_pts=n_valid_ion
    sig_b=b_field_sig_ion
    pparl_ion=p_prl_ion_ion
    pperp_ion=p_prp_ion_ion
    pparl_ele=p_prl_ele_ion
    pperp_ele=p_prp_ele_ion

     n=n_valid_pts
     ;make differences
     com_mass=1.6e-24+9.1e-28   ; cgs
     rhocm=com_mass*den_e_2sw    ; make this the same whether electrons or ions... ie from electrons.... den_e should always be used not ion
     delta_vx_i=fltarr(n^2)
     delta_vy_i=fltarr(n^2)
     delta_vz_i=fltarr(n^2)
     delta_bx_o_rho_i=fltarr(n^2)
     delta_by_o_rho_i=fltarr(n^2)
     delta_bz_o_rho_i=fltarr(n^2)
     error_vx_i=fltarr(n^2)
     error_vy_i=fltarr(n^2)
     error_vz_i=fltarr(n^2)
     error_bx_term_i=fltarr(n^2)
     error_by_term_i=fltarr(n^2)
     error_bz_term_i=fltarr(n^2)
     delta_bx_term_i=fltarr(n^2)
     delta_by_term_i=fltarr(n^2)
     delta_bz_term_i=fltarr(n^2)
     icounter=-1
     for jkl=0,n-2 do begin
       for ikl=jkl+1,n-1 do begin
        ;;;;;;;;;;;;;;;;;;;; form all needed differences::::::::::jkl-ikl
;        fractional_error_density_jkl= (statistical_fraction_error_density(jkl)^2 + fractional_var_during_two_sweep(jkl)^2)^0.5
;        fractional_error_density_ikl= (statistical_fraction_error_density(ikl)^2 + fractional_var_during_two_sweep(ikl)^2)^0.5
           
           fractional_error_density_jkl=den_sig_ion(jkl)
           fractional_error_density_ikl=den_sig_ion(ikl)
        nt2G=1.0e-5 
        icounter=icounter+1
        error_vx_i(icounter)=(delta_ui_2sw(jkl,0)^2+delta_ui_2sw(ikl,0)^2)^0.5  ;assumed km/s
        delta_vx_i(icounter)= (ui_2sw(jkl,0)-ui_2sw(ikl,0))                         
        error_vy_i(icounter)=(delta_ui_2sw(jkl,1)^2+delta_ui_2sw(ikl,1)^2)^0.5   ;assumed km/s
        delta_vy_i(icounter)= (ui_2sw(jkl,1)-ui_2sw(ikl,1))                     ;assumed km/s

        error_vz_i(icounter)=(delta_ui_2sw(jkl,2)^2+delta_ui_2sw(ikl,2)^2)^0.5  ;assumed km/s
        delta_vy_i(icounter)= (ui_2sw(jkl,2)-ui_2sw(ikl,2))                     ;assumed km/s

        error_bx_term_i(icounter)=  nt2G*( (b_2sw(jkl,0)/den_e_2sw(jkl)*fractional_error_density_jkl)^2 +  $
                                         (b_2sw(ikl,0)/den_e_2sw(ikl)*fractional_error_density_ikl)^2 +        $
                               (sig_b(jkl,0)/den_e_2sw(jkl))^2 + (sig_b(ikl,0)/den_e_2sw(ikl))^2)^0.5/com_mass
        delta_bx_term_i(icounter)=            nt2G*(b_2sw(jkl,0)/den_e_2sw(jkl)-b_2sw(ikl,0)/den_e_2sw(ikl)) /com_mass
        error_by_term_i(icounter)=  nt2G*( (b_2sw(jkl,1)/den_e_2sw(jkl)*fractional_error_density_jkl)^2 + $
                                         (b_2sw(ikl,1)/den_e_2sw(ikl)*fractional_error_density_ikl)^2 +       $
                               (sig_b(jkl,1)/den_e_2sw(jkl))^2 + (sig_b(ikl,1)/den_e_2sw(ikl))^2)^0.5/com_mass
        delta_by_term_i(icounter)=            nt2G*(b_2sw(jkl,1)/den_e_2sw(jkl)-b_2sw(ikl,1)/den_e_2sw(ikl))/com_mass    
        error_bz_term_i(icounter)=  nt2G*( (b_2sw(jkl,2)/den_e_2sw(jkl)*fractional_error_density_jkl)^2 + $
                               (b_2sw(ikl,2)/den_e_2sw(ikl)*fractional_error_density_ikl)^2 +       $
                               (sig_b(jkl,2)/den_e_2sw(jkl))^2 + (sig_b(ikl,2)/den_e_2sw(ikl))^2)^0.5/com_mass
        delta_bz_term_i(icounter)=                 nt2G*(b_2sw(jkl,2)/den_e_2sw(jkl)-b_2sw(ikl,2)/den_e_2sw(ikl))/com_mass
       endfor  ; ikl
     endfor   ; jkl

     pparl=pparl_ion+pparl_ele ;in ergs/cm
     pperp=pperp_ion+pperp_ele ; in erg/cc
     alpha = 1.0e-5*(rhocm*(1.0d0/4.0d0/!pi - (pparl-pperp)/(1.0d-10*hd_magnitude(b_2sw)^2)))^0.5
     if n_elements(alpha eq 1) then begin
        alpha_avg=alpha(0)
        alpha_var=0
     endif else begin
       slp_stats=moment(alpha)
       alpha_avg=slp_stats(0)
       alpha_sig=sqrt(slp_stats(1))
     endelse
     ;  Theoretically slope with fits below should have slope 1
     ;  Fractional Error is expect to be
     slope_theory=1
     slope_theory_sigma=alpha_sig/alpha_avg
     ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
     ;
     ;      Target Slope is +/-1 + slope_theory_sig
     ;
     ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


     ;
     ;   calculate alpha uncertainty
     ;   if density calibrated correctly Gen_fit slope of delta_v_j vs delta_b_j_alfven should be unity
     ;            to within delta alpha/alpha

     delta_bx_alfven_i= alpha_avg*delta_bx_term_i  ;km/s
     delta_by_alfven_i= alpha_avg*delta_by_term_i  ;km/s
     delta_bz_alfven_i= alpha_avg*delta_bz_term_i  ;km/s
     error_bx_alfven_i= alpha_avg*error_bx_term_i  ;km/s
     error_by_alfven_i= alpha_avg*error_by_term_i  ;km/s
     error_bz_alfven_i= alpha_avg*error_bz_term_i  ;km/s

     x_mean_i_kms=[delta_bx_alfven_i(0:icounter),delta_by_alfven_i(0:icounter),delta_bz_alfven_i(0:icounter)]
     x_err_i_kms =[error_bx_alfven_i(0:icounter),error_by_alfven_i(0:icounter),error_bz_alfven_i(0:icounter)]
     y_mean_i_kms=[delta_vx_i(0:icounter),delta_vy_i(0:icounter),delta_vz_i(0:icounter)]
     y_err_i_kms =[delta_vx_i(0:icounter),delta_vy_i(0:icounter),delta_vz_i(0:icounter)]

     dynamic_range_e=[max(abs(x_mean_e_kms)), max(abs(y_mean_e_kms))]

     gen_fit_wrapper,x=x_mean_i_kms,sigma_x=x_err_i_kms,y=y_mean_i_kms, $
       sigma_y=y_err_i_kms,slope=slope_i,nparms=1,c68=c68_i, $
       ks_c68=ks_c68_i,/force_kappa_search,kappa_data=kappa_data,_extra=e

     print,slope_i,c68_i,ks_c68_i

     stop

finito:

end




