pro plot_chisq_ratio,version1,version2,time_start,time_end,$
                       e_filter=e_filter,print=print,save=save


;+
; pro plot_chisq_ratio
;Plots ratio of reduced chi squared for two selected versions of the two-sweep
;uperp.  
;   Arguments:  version1, string, e.g. 'r'
;               version2, string, e.g. 't'
;               time_start, e.g. '04:00'
;               time_end,   e.g. '08:00'
;   Keywords:   e_filter,   set if you want only times where the E
;                           field is valid.
;               print,      set if you want to save the plot in a
;                           postscript file and print it.
;               save,       set if you want to save the plot in a
;                           postscript file but not print it.
;-
doc_flag=0
if (n_params() lt 4) then doc_flag=1
if (size(version1,/type) ne 7) then doc_flag=1
if (size(version2,/type) ne 7) then doc_flag=1
if (size(time_start,/type) ne 7) then doc_flag=1
if (size(time_end,/type) ne 7) then doc_flag=1
if (doc_flag) then begin
    doc_library,'plot_chisq_ratio'
    return
    stop
endif
date=19960529
;Get decimal start and stop times
doy96_start=gen_time(date=date,time=time_start)
dissect_doy96,doy96_start,iyear,imonth,iday,ihour,imin,isec,imsec
;print,date,time_start,iyear,imonth,iday,ihour,imin,isec,imsec
dec_sec_start=3600.d0*ihour+60.d0*imin+1.d0*isec+1.d-3*imsec
dec_hr_start=dec_sec_start/3600.d0
;print,date,time_start,dec_sec_start,dec_hr_start
;stop

doy96_end=gen_time(date=date,time=time_end)
dissect_doy96,doy96_end,iyear,imonth,iday,ihour,imin,isec,imsec
;print,date,time_start,iyear,imonth,iday,ihour,imin,isec,imsec
dec_sec_end=3600.d0*ihour+60.d0*imin+1.d0*isec+1.d-3*imsec
dec_hr_end=dec_sec_end/3600.d0
;print,date,time_start,dec_sec_end,dec_hr_end
;stop

if (keyword_set(print)) then save=1

filter_title=''
filename_1t='jack_50'+strtrim(version1,2)+'_1.idlsav'
filename_2t='jack_50'+strtrim(version2,2)+'_1.idlsav'

datadir1='/opt/hydra/2sweep_uperp/su_series_19960529/summary/save.50'+$
  strtrim(version1,2)+'/'
datadir2='/opt/hydra/2sweep_uperp/su_series_19960529/summary/save.50'+$
  strtrim(version2,2)+'/'

restore,datadir1+filename_1t
timetags1=timetags
rchisq_1=rchisq_min
hyd_access,timetags1,'time_bin_center_hsm',time_hr_1

restore,datadir2+filename_2t
timetags2=timetags
rchisq_2=rchisq_min
hyd_access,timetags2,'time_bin_center_hsm',time_hr_2

;Select desired time range

a_time_1=where(time_hr_1 ge dec_hr_start and time_hr_1 le dec_hr_end,count_1)
a_time_2=where(time_hr_2 ge dec_hr_start and time_hr_2 le dec_hr_end,count_2)

; Check to see whether all timetags are identical

if (count_1 eq 0 or count_2 eq 0) then stop,'No data in this time range!'
time_1=time_hr_1(a_time_1)
time_2=time_hr_2(a_time_2)
timetags1=timetags1(a_time_1)
timetags2=timetags2(a_time_2)

rchisq_1=rchisq_1(a_time_1)
rchisq_2=rchisq_2(a_time_2)

align=0
if (count_1 ne count_2) then begin
    align=1
endif else begin
    a_wrong=where(time_hr_1 ne time_hr_2,acount)
    if (acount ne 0) then align=1
endelse

if (align) then begin
    i_count=-1
    countmax=min([count_1,count_2])
    time=dblarr(countmax)
    chisq_1=dblarr(countmax)
    chisq_2=dblarr(countmax)
    timetags=timetags1(indgen(countmax))
    for i=0,count_1-1 do begin
        for j=0,count_2-1 do begin
            if (abs(time_1(i)-time_2(j)) lt 0.001) then begin
                i_count=i_count+1
                chisq_1(i_count)=rchisq_1(i)
                chisq_2(i_count)=rchisq_2(j)
                time(i_count)=time_1(i)
                timetags(i_count)=timetags1(i)
                goto,zap
            endif
        endfor
zap:
    endfor
endif else begin
    chisq_1=rchisq_1
    chisq_2=rchisq_2
    time=time_1
    timetags=timetags1
endelse

filt_title='--unfilt'
time=time*3600.d0
if (keyword_set(e_filter)) then begin
    efield_name='NOV13_E_GSM'
    hyd_access,timetags,efield_name,efield
    
    efield_valid=where(efield(*,0) gt -1.e30 or $
                       efield(*,1) gt -1.e30 or $
                       efield(*,2) gt -1.e30, vcount)
    if (vcount eq 0) then begin
        print,'CAUTION:  FILTER FAILED!!!'
    endif
    
;    efield_not_valid=where(efield(*,0) lt -1.e30 and $
;                           efield(*,1) lt -1.e30 and $
;                           efield(*,2) lt -1.e30, nvcount)
    
    timetags_ef=timetags(efield_valid)
;    timetags_nef=timetags(efield_not_valid)
    
    time=time(efield_valid)
    chisq_1=chisq_1(efield_valid)
    chisq_2=chisq_2(efield_valid)

    filt_title='--E_filtered'
endif
dots,/fill

if (keyword_set(save)) then begin
    set_ps,file='chisq_'+version2+'over'+version1+filt_title+'.ps',/reset,$
      /landscape
endif

title='Version '+version2+' / '+version1+':  '+time_start+'--'+time_end+$
  filt_title

y=hd_divide(chisq_2,chisq_1)
afill=where(hd_is_fill(y),fillcount)
if (fillcount ne 0) then y(afill)=-0.5

!x.range=[dec_sec_start,dec_sec_end]
!x.style=1
!y.range=[-1,max(y)]
!y.title='!7v!S!Dm!X,'+version2+'!R!U2  !N/ !7v!S!Dm!X,'+version1+'!R!U2!N'
!x.title='Time, UT'
!p.charsize=1.5
!x.ticks=3
!x.minor=20
plot,time,y,psym=8,symsize=0.5,xtickformat='tick_hms',title=title
if (fillcount ne 0) then begin
    dots
    oplot,time(afill),y(afill),psym=8,symsize=1.5
endif
if (keyword_set(save)) then begin
    label_page
    end_of_prog,print=print
endif
stop

end








