; Given normalized coordinates, return the coordinates on the
; current plot's axes.  The motivation for this procedure was to
; make a way that annotations could be printed within a plot having
; unknown axes.  We might be missing the simple and obvious way to 
; do this, and if you know it please call us.  
;
; Written by: Jeremy Faden, University of Iowa. 
;             jbf@space-theory.physics.uiowa.edu

function norm_axis, n_coord
  return=fltarr(2)
  return(0)=!x.crange(0)+(!x.crange(1)-!x.crange(0))*n_coord(0)
  return(1)=!y.crange(0)+(!y.crange(1)-!y.crange(0))*n_coord(1)
  
  return, return
end
;=====================================================================
PRO plot_walen, interval, interval_ion, rdflag, print=print, ps=ps, gif=gif, nwindow=nwindow, titstr_ele=titstr_ele, titstr_ion=titstr_ion, iontoo=iontoo, contig=contig,bnorm_over_b=bnorm_over_b,reduced=reduced, agu_plot=agu_plot, may29_plot = may29_plot

   COMMON rds_blocks, cread, cnorm, cdate, $
    data, data_version_moments_ele, data_version_moments_ion, $
    bangles, time_bangles, dt_bangles, hand_bangles, $
    t54, bx54, by54, bz54, $
    hrdata, data_version_hr_ele, $
    ephemdata

   COMMON rds_walen_minvar_blocks, $
    bnorm2_time,bnorm2_avg,bnorm2_sig,bnorm2_angle,bnorm2_anglez, $
    bnorm2_eval,bnorm2_evec, $
    nbprime,bprime,tprime,nsec, $
    sf68,sf95,st,r2,both,f1,kappa,kappamin_index, $
    npick2, picked, orig_mask, orig_interval, orig_picked,$
    nfit,xfit,yfit,sigxfit,sigyfit,labelfit

   COMMON map_blocks, mapinds_grid_mom, mapinds_mom_grid

   COMMON rds_walen_ion_blocks, $
    sf68_ion,sf95_ion,st_ion,r2_ion,both_ion,$
    f1_ion,kappa_ion,kappamin_index_ion, $
    picked_ion, orig_mask_ion,orig_interval_ion,orig_picked_ion,$
    nfit_ion,xfit_ion,yfit_ion,sigxfit_ion,sigyfit_ion,labelfit_ion

   COMMON rds_walen_reduced_blocks, $
    sf68_rele,sf95_rele,st_rele,r2_rele,both_rele,$
    f1_rele,kappa_rele,kappamin_index_rele, $
    nfit_rele,xfit_rele,yfit_rele,sigxfit_rele,sigyfit_rele,labelfit_rele, $
    sf68_rion,sf95_rion,st_rion,r2_rion,both_rion,$
    f1_rion,kappa_rion,kappamin_index_rion, $
    nfit_rion,xfit_rion,yfit_rion,sigxfit_rion,sigyfit_rion,labelfit_rion 

   if keyword_set(gif) then gif=1 else gif=0
   if keyword_set(iontoo) then iontoo=1 else iontoo=0
   if keyword_set(nwindow) then nwindow=nwindow else nwindow=0
   if keyword_set(ps) then ps=1 else ps=0
   if keyword_set(print) then print=1 else print=0

   IF (NOT print AND NOT ps AND NOT gif AND iontoo and not keyword_set(may29_plot)) THEN window,nwindow,xsize=800,ysize=800 ELSE IF (NOT print AND NOT ps AND NOT gif AND NOT iontoo and not keyword_set(may29_plot)) THEN window,nwindow,xsize=600,ysize=800

   IF (gif EQ 1 OR (print EQ 0 AND ps EQ 0)) THEN BEGIN 
      outsize = 1.2
      pltsize = 1.2
      symsize = 1
   ENDIF ELSE BEGIN
       if (not keyword_set(agu_plot) and not keyword_set(may29_plot)) then begin
           outsize = .6
           pltsize = .75
           symsize = .75
       endif else if (not keyword_set(agu_plot) and keyword_set(may29_plot)) then begin
           outsize= .75
           pltsize = 1.35
           symsize = .5
       endif else if (keyword_set(agu_plot) and not keyword_set(may29_plot)) then begin
           outsize = 0.75
           pltsize = 0.85
           symsize = 0.75
       endif
   ENDELSE
   
   hydra_setcolors, cs
;   outs = fltarr(20,2)
   outs=fltarr(200,2)
   
   IF (iontoo) THEN begin
       !p.multi = [0,2,2,0,1]
   endif else if (not iontoo and not keyword_set(agu_plot) and not keyword_set(may29_plot)) then begin
       !p.multi = [0,1,2]
   endif else if (not iontoo and keyword_set(agu_plot) and not keyword_set(may29_plot)) then begin
       !p.multi = [0,1,2]
   endif

   if keyword_set(agu_plot) then begin
       fitplot_tit_ele = titstr_ele
       fitplot_tit_ion = titstr_ion
   endif else if keyword_set(may29_plot) then begin
       fitplot_tit_ele = titstr_ele
   endif else begin
       fitplot_tit_ele = ' '
       fitplot_tit_ion = ' '
   endelse
   
   font = '!5'
   xsymvec = fltarr(3,4)
   ysymvec = fltarr(3,4)
   xsymvec(0,*) = [-1,0,1,0] & ysymvec(0,*) = [0,1,0,-1] ; Diamond
   a = 2.*tan(30.*!pi/180.)
   xsymvec(1,*) = [-a,0,a,-a] & ysymvec(1,*)=[-1,1,-1,-1] ; Triangle
   a = sqrt(2)/2.
   xsymvec(2,*) = [-a,a,a,-a] & ysymvec(2,*)=[a,a,-a,-a] ; Square

; Define the variables for this particular interval
   
   IF NOT keyword_set(reduced) THEN BEGIN 
      nf = nfit(interval)   
      f2 = reform(f1(*,interval))
      kappa2 = reform(kappa(*,interval))/float(nf-1-1) ; REDUCED chi2
      kappamin_index2 = kappamin_index(interval)
      x = reform(xfit(0:nf-1,interval))
      y = reform(yfit(0:nf-1,interval))
      sigy = reform(sigyfit(0:nf-1,interval))
      sigx = reform(sigxfit(0:nf-1,interval))
      labelstr = reform(labelfit(0:nf-1,interval))
      nparms = 1
      slope = sf68(1,interval)
      if (slope ge 0.) then begin
      slope_sigma_68left = abs(sf68(1,interval)-sf68(0,interval))
      slope_sigma_68right = abs(sf68(1,interval)-sf68(2,interval))
      slope_sigma_95left = abs(sf95(1,interval)-sf95(0,interval))
      slope_sigma_95right = abs(sf95(1,interval)-sf95(2,interval))
      endif else begin
          slope_sigma_68right = abs(sf68(1,interval)-sf68(0,interval))
          slope_sigma_68left = abs(sf68(1,interval)-sf68(2,interval))
          slope_sigma_95right = abs(sf95(1,interval)-sf95(0,interval))
          slope_sigma_95left = abs(sf95(1,interval)-sf95(2,interval))
      endelse      
      slopemax = abs(sf68(2,interval))
      slopemin = abs(sf68(0,interval))
      slopetheory_max = abs(st(2,interval))
      slopetheory_min = abs(st(0,interval))
      intercept = 0.
      rchisq = r2(interval)
      slope_theory = st(1,interval)
      slope_theory_sigma = abs(st(1,interval)-st(0,interval))
      both68 = both(0,interval)
      both95 = both(1,interval)
   ENDIF ELSE BEGIN
      nf = nfit_rele(interval)   
      f2 = reform(f1_rele(*,interval))
      kappa2 = reform(kappa_rele(*,interval))/float(nf-1-1) ; REDUCED chi2
      kappamin_index2 = kappamin_index_rele(interval)
      x = reform(xfit_rele(0:nf-1,interval))
      y = reform(yfit_rele(0:nf-1,interval))
      sigy = reform(sigyfit_rele(0:nf-1,interval))
      sigx = reform(sigxfit_rele(0:nf-1,interval))
      labelstr = reform(labelfit_rele(0:nf-1,interval))
      nparms = 1
      slope = sf68_rele(1,interval)
      slope_sigma_68left = abs(sf68_rele(1,interval)-sf68_rele(0,interval))
      slope_sigma_68right = abs(sf68_rele(1,interval)-sf68_rele(2,interval))
      slope_sigma_95left = abs(sf95_rele(1,interval)-sf95_rele(0,interval))
      slope_sigma_95right = abs(sf95_rele(1,interval)-sf95_rele(2,interval))
      slopemax = abs(sf68_rele(2,interval))
      slopemin = abs(sf68_rele(0,interval))
      slopetheory_max = abs(st_rele(2,interval))
      slopetheory_min = abs(st_rele(0,interval))
      intercept = 0.
      rchisq = r2_rele(interval)
      slope_theory = st_rele(1,interval)
      slope_theory_sigma = abs(st_rele(1,interval)-st_rele(0,interval))
      both68 = both_rele(0,interval)
      both95 = both_rele(1,interval)
   ENDELSE 

   wmi = picked(interval,1:picked(interval,0))

   IF (keyword_set(contig)) THEN orig_wmi = wmi ELSE orig_wmi = orig_picked(interval,1:orig_picked(interval,0))

   
   if (keyword_set(agu_plot) or keyword_set(may29_plot)) then goto, agu_ele

; Kappa Picture ---------------------------------------
   xrange = [f2(0),f2(n_elements(f2)-1)]
   
   IF (kappa2(kappamin_index2) GE 10.) THEN BEGIN
      yrange = [10,1000]
   ENDIF ELSE BEGIN
      yrange = [.1,100]
   ENDELSE
   

   plot,f2,kappa2,xtitle=font+'!7a!x!dw!n (Walen Slope)',ytitle=font+'!7v!dm!x!n!u2!n',xstyle=1,ystyle=1,xrange=xrange,title=titstr_ele,/ylog,yrange=yrange,charsize=pltsize,/nodata,ymargin=[4,4],xmargin=[10,6]
   
;   polyfill,[f2(0),f2(n_elements(f2)-1),f2(n_elements(f2)-1),f2(0)],[kappa2(kappamin_index2)+3.84,kappa2(kappamin_index2)+3.84,kappa2(kappamin_index2),kappa2(kappamin_index2)],/data,color=53,noclip=0
   
;   polyfill,[f2(0),f2(n_elements(f2)-1),f2(n_elements(f2)-1),f2(0)],[kappa2(kappamin_index2)+1.,kappa2(kappamin_index2)+1.,kappa2(kappamin_index2),kappa2(kappamin_index2)],/data,color=76,noclip=0
   
   oplot, f2,kappa2
   
   oplot, [f2(kappamin_index2),f2(kappamin_index2)],[min(kappa2),max(kappa2)],line=0
   
   oplot, [f2(kappamin_index2)-slope_sigma_68left,f2(kappamin_index2)-slope_sigma_68left],[min(kappa2),max(kappa2)],line=2
   oplot, [f2(kappamin_index2)+slope_sigma_68right,f2(kappamin_index2)+slope_sigma_68right],[min(kappa2),max(kappa2)],line=2
   
   oplot, [f2(kappamin_index2)-slope_sigma_95left,f2(kappamin_index2)-slope_sigma_95left],[min(kappa2),max(kappa2)],line=4
   oplot, [f2(kappamin_index2)+slope_sigma_95right,f2(kappamin_index2)+slope_sigma_95right],[min(kappa2),max(kappa2)],line=4

;------------------------
; FIT RESULTS
;------------------------
   outs(0,*) = norm_axis([.55,.85]) & outs(0,1)=10^(outs(0,1))
   outs(1,*) = norm_axis([.55,.75]) & outs(1,1)=10^(outs(1,1))
   outs(2,*) = norm_axis([.55,.65]) & outs(2,1)=10^(outs(2,1))
   outs(3,*) = norm_axis([.55,.55]) & outs(3,1)=10^(outs(3,1))
   outs(4,*) = norm_axis([.55,.45]) & outs(4,1)=10^(outs(4,1))

   slp_sig_avg = (slope_sigma_68left+slope_sigma_68right)/2.
;   xyouts,outs(0,0),outs(0,1),font+'!7a!x!dw,fit!n = '+string(slope,'(f5.2)')+' !9+!x '+ $
;    string(slp_sig_avg,'(f4.2)'),charsize=outsize

   xyouts,outs(0,0),outs(0,1),font+'!7a!x!dw,fit!n = '+string(slope,'(f5.2)')+' - '+string(slope_sigma_68left,'(f4.2)'),charsize=outsize
   xyouts,outs(0,0),(outs(0,1)+outs(1,1))/2.0,font+'              + '+string(slope_sigma_68right,'(f4.2)'),charsize=outsize

   xyouts,outs(1,0),outs(1,1),font+'!7v!x!s!u2!n!r!d!7m!x,fit!n = '+ string(rchisq,'(f5.2)'), $
    charsize=outsize

   xyouts,outs(2,0),outs(2,1),font+'!7a!x!dw,theory!n = '+string(slope_theory,'(f5.2)')+ $
    ' !9+!x '+string(slope_theory_sigma,'(f4.2)'),charsize=outsize

   xyouts,outs(3,0),outs(3,1),font+'B!dn!n/B = '+string(bnorm_over_b,'(f5.2)'),charsize=outsize

;   xyouts,.75,.84,font+'SLOPE-C68: ' +string(slope-slope_sigma_68left,'(e9.2)'),/normal,charsize=outsize
;   xyouts,.75,.81,font+'SLOPE+C68: ' +string(slope+slope_sigma_68right,'(e9.2)'),/normal,charsize=outsize
;   xyouts,.75,.78,font+'BOTH68: ' + string(both68,'(i1)'),/normal,charsize=outsize
;   xyouts,.75,.75,font+'BOTH95: ' + string(both95,'(i1)'),/normal,charsize=outsize
;   xyouts,.75,.66,font+'NPARMS: '+string(nparms,'(i2)'),/normal,charsize=outsize

;------------------------
; MEASUREMENTS INDICES
;------------------------
   outs(5,*) = norm_axis([.1,.9]) & outs(5,1)=10^(outs(5,1))
   outs(6,*) = norm_axis([.2,.85]) & outs(6,1)=10^(outs(6,1))
   outs(7,*) = norm_axis([.2,.8]) & outs(7,1)=10^(outs(7,1))
   outs(8,*) = norm_axis([.2,.75]) & outs(8,1)=10^(outs(8,1))
   outs(9,*) = norm_axis([.2,.7]) & outs(9,1)=10^(outs(9,1))
   outs(10,*) = norm_axis([.2,.65]) & outs(10,1)=10^(outs(10,1))
   outs(11,*) = norm_axis([.2,.60]) & outs(11,1)=10^(outs(11,1))
   outs(12,*) = norm_axis([.2,.55]) & outs(12,1)=10^(outs(12,1))
   outs(13,*) = norm_axis([.2,.50]) & outs(13,1)=10^(outs(13,1))
   outs(14,*) = norm_axis([.2,.45]) & outs(14,1)=10^(outs(14,1))
   outs(15,*) = norm_axis([.2,.40]) & outs(15,1)=10^(outs(15,1))
   outs(16,*) = norm_axis([.2,.35]) & outs(16,1)=10^(outs(16,1))
   outs(17,*) = norm_axis([.2,.30]) & outs(17,1)=10^(outs(17,1))

   xyouts,outs(5,0),outs(5,1),font+'Measurement indices: ',charsize=outsize
   FOR iii=0,n_elements(orig_wmi)-1 DO BEGIN
      check = where(wmi EQ orig_wmi(iii))
      strout = string(mapinds_mom_grid(orig_wmi(iii)),'(i4.4)')
      IF (check(0) NE -1) THEN strout = strout + font+' !9C'+font
      xyouts,outs(6+iii,0),outs(6+iii,1),strout,charsize=outsize
   ENDFOR

   oplot, !x.crange, [1,1], line=3


;-------------------------
; REFERENCE INDEX (for my own purposes)
;-------------------------
   outs(18,*) = norm_axis([.9,.05]) & outs(18,1)=10^(outs(18,1))
   outs(19,*) = norm_axis([.9,.1]) & outs(19,1)=10^(outs(19,1))
   xyouts, outs(18,0),outs(18,1),'REF:'+string(interval,'(i4.4)'),charsize=outsize,alignment=.5
   IF (NOT keyword_set(contig)) THEN BEGIN 
      orig_index = orig_interval(interval)
      ro = where(orig_interval EQ orig_index)
      onum = interval - ro(0) + 1
      xyouts, outs(19,0), outs(19,1),'ORIG:'+string(orig_index,'(i2.2)')+' ('+string(onum,'(i4.4)')+' of '+string(n_elements(ro),'(i4.4)')+')',alignment=.5
   ENDIF

; Walen picture ---------------------------------------------------

   agu_ele:
   
;   ybig = max( [abs(y-sigy),abs(y+sigy)] )
;   xbig = max( [abs(x-sigx),abs(x+sigx)] )
   ybig = max( [abs(y),abs(y)] )
   xbig = max( [abs(x),abs(x)] )
   
   biggest = max([xbig,ybig])
   xrange = [-biggest,biggest]
   yrange = [-biggest,biggest]

   xrange_ele = xrange
   yrange_ele = yrange
   
   if keyword_set(agu_plot) then ytitle = font+'!7D!xU!dele,obs!n (km/s)' else $
     ytitle = font+'[U!de!n]!d!18j!x!n (km/s)'
   if keyword_set(agu_plot) then xtitle = font+'!7D!xU!dele,theory!n (km/s)' else $
;     xtitle = font+'!7a!x!d!7R!x!n [B/(m!dp!n+m!de!n)(n!de!n!9X!X2.3)]!d!18j!x!n  (km/s)'
     xtitle = font+'!7a!x!d!7R!x!n [B/(m!dp!n+m!de!n)(n!de!n)]!d!18j!x!n  (km/s)'
   plot, x, y, psym=3, xrange=xrange, yrange=yrange, xstyle=1, ystyle=1,$
    xtitle=xtitle, $
    ytitle=ytitle,charsize=pltsize,xmargin=[10,6],ymargin=[4,4], title=$
     fitplot_tit_ele
   
   xfit2 = findgen(10)*(xrange(1)+100-(xrange(0)-100))/9. + xrange(0)-100
   yfit2 = slope*xfit2 + intercept
   
   polycol = cs.grey
; Slope=1
   polyfill,[0,xfit2(9),xfit2(9)],[0,(slope_theory+slope_theory_sigma)*xfit2(9),(slope_theory-slope_theory_sigma)*xfit2(9)],/data,color=polycol,noclip=0
   polyfill,[0,xfit2(0),xfit2(0)],[0,(slope_theory+slope_theory_sigma)*xfit2(0),(slope_theory-slope_theory_sigma)*xfit2(0)],/data,color=polycol,noclip=0
   
; Slope=-1
   polyfill,[0,xfit2(9),xfit2(9)],[0,-(slope_theory+slope_theory_sigma)*xfit2(9),-(slope_theory-slope_theory_sigma)*xfit2(9)],/data,color=polycol,noclip=0
   polyfill,[0,xfit2(0),xfit2(0)],[0,-(slope_theory+slope_theory_sigma)*xfit2(0),-(slope_theory-slope_theory_sigma)*xfit2(0)],/data,color=polycol,noclip=0
   
   oplot, xfit2, yfit2, line=3
   oplot, xfit2, (slope-slope_sigma_68left)*xfit2 + intercept,line=2
   oplot, xfit2, (slope+slope_sigma_68right)*xfit2 + intercept,line=2
   
;      oplot, xfit2, xfit2, line=0
   

;-----------------------
; COMPONENT LABELS
;-----------------------
   outs(0,*) = norm_axis([.45,.95])
   outs(1,*) = norm_axis([.45,.90])
   outs(2,*) = norm_axis([.45,.85])

   xlen = xrange(1)-xrange(0)

   usersym, xsymvec(0,*),ysymvec(0,*), /fill
   oplot, [outs(0,0)-.05*xlen,outs(0,0)-.05*xlen],[outs(0,1),outs(0,1)],psym=8,symsize=symsize
   xyouts,outs(0,0),outs(0,1),font+'!bX-COMP!n',charsize=outsize
   
   usersym, xsymvec(1,*),ysymvec(1,*), /fill
   oplot, [outs(1,0)-.05*xlen,outs(1,0)-.05*xlen],[outs(1,1),outs(1,1)],psym=8,symsize=symsize
   xyouts,outs(1,0),outs(1,1),font+'!bY-COMP!n',charsize=outsize
   
   usersym, xsymvec(2,*),ysymvec(2,*), /fill
   oplot, [outs(2,0)-.05*xlen,outs(2,0)-.05*xlen],[outs(2,1),outs(2,1)],psym=8,symsize=symsize
   xyouts,outs(2,0),outs(2,1),font+'!bZ-COMP!n',charsize=outsize

   rr = where(strmid(labelstr,0,1) EQ 'X')
   bb = where(strmid(labelstr,0,1) EQ 'Y')
   gg = where(strmid(labelstr,0,1) EQ 'Z')
   
   usersym, xsymvec(0,*),ysymvec(0,*), /fill
   oplot, x(rr),y(rr),psym=8,symsize=symsize
   usersym, xsymvec(1,*),ysymvec(1,*), /fill
   oplot, x(bb),y(bb),psym=8,symsize=symsize
   usersym, xsymvec(2,*),ysymvec(2,*), /fill
   oplot, x(gg),y(gg),psym=8,symsize=symsize
   
   FOR i=0,n_elements(x)-1 DO BEGIN
      oplot, [x(i),x(i)],[y(i)-sigy(i),y(i)+sigy(i)],line=0
      oplot, [x(i)-sigx(i),x(i)+sigx(i)],[y(i),y(i)],line=0
   ENDFOR

   if (keyword_set(agu_plot)) then begin
       outs3 = norm_axis([.5,.15])
       xyouts,outs3(0),outs3(1),font+'Electron Data Fit',charsize=outsize, alignment=.5
       outs1 = norm_axis([.5,.1])
       slp_sig_avg = (slope_sigma_68left+slope_sigma_68right)/2.
       xyouts,outs1(0),outs1(1),font+'Walen Slope = '+string(slope,'(f5.2)')+' !9+!x '+ $
         string(slp_sig_avg,'(f4.2)'),charsize=outsize, alignment=.5
   endif

   if (keyword_set(may29_plot)) then begin

       outs1 = norm_axis([.5,.19])
       slp_sig_avg = (slope_sigma_68left+slope_sigma_68right)/2.
       xyouts,outs1(0),outs1(1),font+'!7a!x!dfit!n = '+string(slope,'(f5.2)')+' !9+!x '+ $
         string(slp_sig_avg,'(f4.2)'),charsize=outsize, alignment=.5

       outs1 = norm_axis([.5,.12])
       xyouts,outs1(0),outs1(1),font+'!7a!x!dtheory!n = '+string(slope_theory,'(f5.2)')+ $
    ' !9+!x '+string(slope_theory_sigma,'(f4.2)'),charsize=outsize, alignment=.5

       outs1 = norm_axis([.5,.05])
       xyouts,outs1(0),outs1(1),font+'!7v!dm!n!x!u2!n = '+ string(rchisq,'(f5.2)'), $
    charsize=outsize, alignment=.5

   endif

   IF (NOT iontoo or keyword_set(may29_plot)) THEN GOTO, skip_ion

;*******************************************************************
;***********ION ION ION ION ION ION ION ION ION ION ****************
;*******************************************************************


; Define the variables for this particular interval

   IF NOT keyword_set(reduced) THEN BEGIN 
      nf = nfit_ion(interval_ion)   
      f2 = reform(f1_ion(*,interval_ion))
      kappa2 = reform(kappa_ion(*,interval_ion))/float(nf-1-1) ; REDUCED chi2
      kappamin_index2 = kappamin_index_ion(interval_ion)
      x = reform(xfit_ion(0:nf-1,interval_ion))
      y = reform(yfit_ion(0:nf-1,interval_ion))
      sigy = reform(sigyfit_ion(0:nf-1,interval_ion))
      sigx = reform(sigxfit_ion(0:nf-1,interval_ion))
      labelstr = reform(labelfit_ion(0:nf-1,interval_ion))
      
      nparms = 1
      slope = sf68_ion(1,interval_ion)
      slope_sigma_68left = abs(sf68_ion(1,interval_ion)-sf68_ion(0,interval_ion))
      slope_sigma_68right = abs(sf68_ion(1,interval_ion)-sf68_ion(2,interval_ion))
      slope_sigma_95left = abs(sf95_ion(1,interval_ion)-sf95_ion(0,interval_ion))
      slope_sigma_95right = abs(sf95_ion(1,interval_ion)-sf95_ion(2,interval_ion))

      slopemax = abs(sf68_ion(2,interval_ion))
      slopemin = abs(sf68_ion(0,interval_ion))
      slopetheory_max = abs(st_ion(2,interval_ion))
      slopetheory_min = abs(st_ion(0,interval_ion))
      intercept = 0.
      rchisq = r2_ion(interval_ion)
      slope_theory = st_ion(1,interval_ion)
      slope_theory_sigma = abs(st_ion(1,interval_ion)-st_ion(0,interval_ion))
      both68 = both_ion(0,interval_ion)
      both95 = both_ion(1,interval_ion)
   ENDIF ELSE BEGIN 
      nf = nfit_rion(interval_ion)   
      f2 = reform(f1_rion(*,interval_ion))
      kappa2 = reform(kappa_rion(*,interval_ion))/float(nf-1-1) ; REDUCED chi2
      kappamin_index2 = kappamin_index_rion(interval_ion)
      x = reform(xfit_rion(0:nf-1,interval_ion))
      y = reform(yfit_rion(0:nf-1,interval_ion))
      sigy = reform(sigyfit_rion(0:nf-1,interval_ion))
      sigx = reform(sigxfit_rion(0:nf-1,interval_ion))

      labelstr = reform(labelfit_rion(0:nf-1,interval_ion))
      nparms = 1
      slope = sf68_rion(1,interval_ion)
      slope_sigma_68left = abs(sf68_rion(1,interval_ion)-sf68_rion(0,interval_ion))
      slope_sigma_68right = abs(sf68_rion(1,interval_ion)-sf68_rion(2,interval_ion))
      slope_sigma_95left = abs(sf95_rion(1,interval_ion)-sf95_rion(0,interval_ion))
      slope_sigma_95right = abs(sf95_rion(1,interval_ion)-sf95_rion(2,interval_ion))
      slopemax = abs(sf68_rion(2,interval_ion))
      slopemin = abs(sf68_rion(0,interval_ion))
      slopetheory_max = abs(st_rion(2,interval_ion))
      slopetheory_min = abs(st_rion(0,interval_ion))
      intercept = 0.
      rchisq = r2_rion(interval_ion)
      slope_theory = st_rion(1,interval_ion)
      slope_theory_sigma = abs(st_rion(1,interval_ion)-st_rion(0,interval_ion))
      both68 = both_rion(0,interval_ion)
      both95 = both_rion(1,interval_ion)
   ENDELSE

   wmi = picked_ion(interval_ion,1:picked_ion(interval_ion,0))
   IF (keyword_set(contig)) THEN orig_wmi = wmi ELSE orig_wmi = orig_picked_ion(interval_ion,1:orig_picked_ion(interval_ion,0))

   if (keyword_set(agu_plot)) then goto, agu_ion
   
; Kappa Picture ---------------------------------------
   xrange = [f2(0),f2(n_elements(f2)-1)]
   
   IF (kappa2(kappamin_index2) GE 10.) THEN BEGIN
      yrange = [10,1000]
   ENDIF ELSE BEGIN
      yrange = [.1,100]
   ENDELSE
   
   plot,f2,kappa2,xtitle=font+'!7a!x!dw!n (Walen Slope)',ytitle=font+'!7v!dm!x!n!u2!n',xstyle=1,ystyle=1,xrange=xrange,title=titstr_ion,/ylog,yrange=yrange,charsize=pltsize,/nodata,ymargin=[4,4],xmargin=[10,6]
   
;   polyfill,[f2(0),f2(n_elements(f2)-1),f2(n_elements(f2)-1),f2(0)],[kappa2(kappamin_index2)+3.84,kappa2(kappamin_index2)+3.84,kappa2(kappamin_index2),kappa2(kappamin_index2)],/data,color=53,noclip=0
   
;   polyfill,[f2(0),f2(n_elements(f2)-1),f2(n_elements(f2)-1),f2(0)],[kappa2(kappamin_index2)+1.,kappa2(kappamin_index2)+1.,kappa2(kappamin_index2),kappa2(kappamin_index2)],/data,color=76,noclip=0
   
   oplot, f2,kappa2
   
   oplot, [f2(kappamin_index2),f2(kappamin_index2)],[min(kappa2),max(kappa2)],line=0
   
   oplot, [f2(kappamin_index2)-slope_sigma_68left,f2(kappamin_index2)-slope_sigma_68left],[min(kappa2),max(kappa2)],line=2
   oplot, [f2(kappamin_index2)+slope_sigma_68right,f2(kappamin_index2)+slope_sigma_68right],[min(kappa2),max(kappa2)],line=2
   
   oplot, [f2(kappamin_index2)-slope_sigma_95left,f2(kappamin_index2)-slope_sigma_95left],[min(kappa2),max(kappa2)],line=4
   oplot, [f2(kappamin_index2)+slope_sigma_95right,f2(kappamin_index2)+slope_sigma_95right],[min(kappa2),max(kappa2)],line=4

;------------------------
; FIT RESULTS
;------------------------
;   outs(0,*) = norm_axis([.55,.85]) & outs(0,1)=10^(outs(0,1))
;   outs(1,*) = norm_axis([.55,.75]) & outs(1,1)=10^(outs(1,1))
;   outs(2,*) = norm_axis([.55,.65]) & outs(2,1)=10^(outs(2,1))
;   outs(3,*) = norm_axis([.55,.55]) & outs(3,1)=10^(outs(3,1))
;   outs(4,*) = norm_axis([.55,.45]) & outs(4,1)=10^(outs(4,1))

   outs(0,*) = norm_axis([.70,.85]) & outs(0,1)=10^(outs(0,1))
   outs(1,*) = norm_axis([.70,.75]) & outs(1,1)=10^(outs(1,1))
   outs(2,*) = norm_axis([.70,.65]) & outs(2,1)=10^(outs(2,1))
   outs(3,*) = norm_axis([.70,.55]) & outs(3,1)=10^(outs(3,1))
   outs(4,*) = norm_axis([.70,.45]) & outs(4,1)=10^(outs(4,1))

   slp_sig_avg = (slope_sigma_68left+slope_sigma_68right)/2.
;   xyouts,outs(0,0),outs(0,1),font+'!7a!x!dw,fit!n = '+string(slope,'(f5.2)')+' !9+!x '+ $
;    string(slp_sig_avg,'(f4.2)'),charsize=outsize

   xyouts,outs(0,0),outs(0,1),font+'!7a!x!dw,fit!n = '+string(slope,'(f5.2)')+' - ' +string(slope_sigma_68left,'(f4.2)'),charsize=outsize
   xyouts,outs(0,0),(outs(0,1)+outs(1,1))/2., $
     font+'              + '+ $
     string(slope_sigma_68right,'(f4.2)'),charsize=outsize


   xyouts,outs(1,0),outs(1,1),font+'!7v!x!s!u2!n!r!d!7m!x,fit!n = '+ string(rchisq,'(f5.2)'), $
    charsize=outsize

   xyouts,outs(2,0),outs(2,1),font+'!7a!x!dw,theory!n = '+string(slope_theory,'(f5.2)')+ $
    ' !9+!x '+string(slope_theory_sigma,'(f4.2)'),charsize=outsize

;   xyouts,.75,.84,font+'SLOPE-C68: ' +string(slope-slope_sigma_68left,'(e9.2)'),/normal,charsize=outsize
;   xyouts,.75,.81,font+'SLOPE+C68: ' +string(slope+slope_sigma_68right,'(e9.2)'),/normal,charsize=outsize
;   xyouts,.75,.78,font+'BOTH68: ' + string(both68,'(i1)'),/normal,charsize=outsize
;   xyouts,.75,.75,font+'BOTH95: ' + string(both95,'(i1)'),/normal,charsize=outsize
;   xyouts,.75,.66,font+'NPARMS: '+string(nparms,'(i2)'),/normal,charsize=outsize

;------------------------
; MEASUREMENTS INDICES
;------------------------
   outs(5,*) = norm_axis([.1,.9]) & outs(5,1)=10^(outs(5,1))
   outs(6,*) = norm_axis([.2,.85]) & outs(6,1)=10^(outs(6,1))
   outs(7,*) = norm_axis([.2,.8]) & outs(7,1)=10^(outs(7,1))
   outs(8,*) = norm_axis([.2,.75]) & outs(8,1)=10^(outs(8,1))
   outs(9,*) = norm_axis([.2,.7]) & outs(9,1)=10^(outs(9,1))
   outs(10,*) = norm_axis([.2,.65]) & outs(10,1)=10^(outs(10,1))
   outs(11,*) = norm_axis([.2,.60]) & outs(11,1)=10^(outs(11,1))
   outs(12,*) = norm_axis([.2,.55]) & outs(12,1)=10^(outs(12,1))
   outs(13,*) = norm_axis([.2,.50]) & outs(13,1)=10^(outs(13,1))
   outs(14,*) = norm_axis([.2,.45]) & outs(14,1)=10^(outs(14,1))
   outs(15,*) = norm_axis([.2,.40]) & outs(15,1)=10^(outs(15,1))
   outs(16,*) = norm_axis([.2,.35]) & outs(16,1)=10^(outs(16,1))
   outs(17,*) = norm_axis([.2,.30]) & outs(17,1)=10^(outs(17,1))

   xyouts,outs(5,0),outs(5,1),font+'Measurement indices: ',charsize=outsize
   FOR iii=0,n_elements(orig_wmi)-1 DO BEGIN
       check = where(wmi EQ orig_wmi(iii))
       strout = string(mapinds_mom_grid(orig_wmi(iii)),'(i4.4)')
;;;This line added by ddm
;       denratout='n!Di!N/n!De!N = '+ $
;         string(data(mapinds_mom_grid(orig_wmi(iii))).density_ion/ $
;                data(mapinds_mom_grid(orig_wmi(iii))).density_ele, $
;                format='(f6.2)')
;;;
       IF (check(0) NE -1) THEN strout = strout + font+' !9C'+font
      xyouts,outs(6+iii,0),outs(6+iii,1),strout, $   ; +' '+denratout, $
        charsize=outsize
   ENDFOR

   oplot, !x.crange, [1,1], line=3

;-------------------------
; REFERENCE INDEX (for my own purposes)
;-------------------------
   outs(18,*) = norm_axis([.9,.05]) & outs(18,1)=10^(outs(18,1))
   outs(19,*) = norm_axis([.9,.1]) & outs(19,1)=10^(outs(19,1))
   xyouts, outs(18,0),outs(18,1),'REF:'+string(interval_ion,'(i4.4)'),charsize=outsize,alignment=.5
   IF (NOT keyword_set(contig)) THEN BEGIN
      orig_index = orig_interval_ion(interval_ion)
      ro = where(orig_interval_ion EQ orig_index)
      onum = interval_ion - ro(0) + 1
      xyouts, outs(19,0), outs(19,1),'ORIG:'+string(orig_index,'(i2.2)')+' ('+string(onum,'(i4.4)')+' of '+string(n_elements(ro),'(i4.4)')+')',alignment=.5
   ENDIF

; Walen picture ---------------------------------------------------
   agu_ion:
   
;   ybig = max( [abs(y-sigy),abs(y+sigy)] )
;   xbig = max( [abs(x-sigx),abs(x+sigx)] )
   
   ybig = max( [abs(y),abs(y)] )
   xbig = max( [abs(x),abs(x)] )
   
   biggest = max([xbig,ybig])
   xrange = [-biggest,biggest]
   yrange = [-biggest,biggest]

   xrange = xrange_ele
   yrange = yrange_ele
   
   if keyword_set(agu_plot) then ytitle = font+'!7D!xU!dion,obs!n (km/s)' else $
     ytitle = font+'[U!d!7R!x!n]!d!18j!x!n (km/s)'
   if keyword_set(agu_plot) then xtitle = font+'!7D!xU!dion,theory!n (km/s)' else $
;     xtitle = font+'!7a!x!d!7R!x!n [B/(!7q!x!d!7R!x!n!9X!X2.3)]!d!18j!x!n (km/s)'
     xtitle = font+'!7a!x!d!7R!x!n [B/(!7q!x!d!7R!x!n)]!d!18j!x!n (km/s)'
   plot, x, y, psym=3, xrange=xrange, yrange=yrange, xstyle=1, ystyle=1, $
    xtitle=xtitle, $
    ytitle=ytitle,charsize=pltsize,xmargin=[10,6],ymargin=[4,4], title=fitplot_tit_ion
   
   xfit2 = findgen(10)*(xrange(1)+100-(xrange(0)-100))/9. + xrange(0)-100
   yfit2 = slope*xfit2 + intercept
   
   polycol = cs.grey
; Slope=1
   polyfill,[0,xfit2(9),xfit2(9)],[0,(slope_theory+slope_theory_sigma)*xfit2(9),(slope_theory-slope_theory_sigma)*xfit2(9)],/data,color=polycol,noclip=0
   polyfill,[0,xfit2(0),xfit2(0)],[0,(slope_theory+slope_theory_sigma)*xfit2(0),(slope_theory-slope_theory_sigma)*xfit2(0)],/data,color=polycol,noclip=0
   
; Slope=-1
   polyfill,[0,xfit2(9),xfit2(9)],[0,-(slope_theory+slope_theory_sigma)*xfit2(9),-(slope_theory-slope_theory_sigma)*xfit2(9)],/data,color=polycol,noclip=0
   polyfill,[0,xfit2(0),xfit2(0)],[0,-(slope_theory+slope_theory_sigma)*xfit2(0),-(slope_theory-slope_theory_sigma)*xfit2(0)],/data,color=polycol,noclip=0
   
   oplot, xfit2, yfit2, line=3
   oplot, xfit2, (slope-slope_sigma_68left)*xfit2 + intercept,line=2
   oplot, xfit2, (slope+slope_sigma_68right)*xfit2 + intercept,line=2
   
;      oplot, xfit2, xfit2, line=0
   

;-----------------------
; COMPONENT LABELS
;-----------------------
   outs(0,*) = norm_axis([.45,.95])
   outs(1,*) = norm_axis([.45,.90])
   outs(2,*) = norm_axis([.45,.85])

   xlen = xrange(1)-xrange(0)

   usersym, xsymvec(0,*),ysymvec(0,*), /fill
   oplot, [outs(0,0)-.05*xlen,outs(0,0)-.05*xlen],[outs(0,1),outs(0,1)],psym=8,symsize=symsize
   xyouts,outs(0,0),outs(0,1),font+'!bX-COMP!n',charsize=outsize
   
   usersym, xsymvec(1,*),ysymvec(1,*), /fill
   oplot, [outs(1,0)-.05*xlen,outs(1,0)-.05*xlen],[outs(1,1),outs(1,1)],psym=8,symsize=symsize
   xyouts,outs(1,0),outs(1,1),font+'!bY-COMP!n',charsize=outsize
   
   usersym, xsymvec(2,*),ysymvec(2,*), /fill
   oplot, [outs(2,0)-.05*xlen,outs(2,0)-.05*xlen],[outs(2,1),outs(2,1)],psym=8,symsize=symsize
   xyouts,outs(2,0),outs(2,1),font+'!bZ-COMP!n',charsize=outsize

   rr = where(strmid(labelstr,0,1) EQ 'X')
   bb = where(strmid(labelstr,0,1) EQ 'Y')
   gg = where(strmid(labelstr,0,1) EQ 'Z')
   
   usersym, xsymvec(0,*),ysymvec(0,*), /fill
   oplot, x(rr),y(rr),psym=8,symsize=symsize
   usersym, xsymvec(1,*),ysymvec(1,*), /fill
; Sometimes when creating the gifs for the web, this oplot fails for no
; apparent reason!
;if (cdate eq '19980504' and interval ne 1) then oplot, x(bb),y(bb),psym=8,symsize=symsize
   oplot, x(bb),y(bb),psym=8,symsize=symsize
   usersym, xsymvec(2,*),ysymvec(2,*), /fill
;   if (cdate eq '19980504' and interval ne 21) then oplot, x(gg),y(gg),psym=8,symsize=symsize

   oplot, x(gg),y(gg),psym=8,symsize=symsize   
   
   FOR i=0,n_elements(x)-1 DO BEGIN
       oplot, [x(i),x(i)],[y(i)-sigy(i),y(i)+sigy(i)],line=0
       oplot, [x(i)-sigx(i),x(i)+sigx(i)],[y(i),y(i)],line=0
   ENDFOR

   if (keyword_set(agu_plot)) then begin
       outs3 = norm_axis([.5,.15])
       xyouts,outs3(0),outs3(1),font+'Ion Data Fit',charsize=outsize, alignment=.5
       outs1 = norm_axis([.5,.1])
       slp_sig_avg = (slope_sigma_68left+slope_sigma_68right)/2.
       xyouts,outs1(0),outs1(1),font+'Walen Slope = '+string(slope,'(f5.2)')+' !9+!x '+ $
         string(slp_sig_avg,'(f4.2)'),charsize=outsize, alignment=.5
   endif
   
   skip_ion:


;   if (keyword_set(agu_plot)) then $
;       xyouts, .5, 1.15, font+cdate+' Polar/Hydra Data!c !cElectron vs. Center-of-Mass Wal!sen Fits!r!9`!x', /normal, charsize=2.0, alignment=.5
;

;   time_stamp
   
   return

END
