pro plot_walen_1,date,time_start_ssm,time_stop_ssm,kappa_data, $
                 x_mean_e_kms,y_mean_e_kms,x_error_e_kms, $
                 y_error_e_kms,ks_c68_e,slope_e,rchisq_e,species=species, $
                 slope_theory,slope_theory_sigma,moment_set=moment_set, $
                 status=status

hydra_setcolors
if (species eq 'ele') then begin
    specstr='Electrons:  '
    if (moment_set eq 'two_swp') then begin
        momsetstr='Two sweep '
    endif else if (moment_set eq 'm3') then begin
        momsetstr='M3 block'
    endif    
endif else if (species eq 'ion') then begin
    specstr='Center of Mass:  '
    if (moment_set eq 'two_swp' or moment_set eq 'm3') $
      then momsetstr='M3 block'
endif

start_str=time_ssm_2_str(time_start_ssm)
end_str=time_ssm_2_str(time_stop_ssm)

if (status eq 1 and slope_e lt 0.0) then begin
    slope_theory=-slope_theory
endif 
titstr = momsetstr+specstr+strtrim(date,2)+',  '+start_str+'--'+end_str
if (status eq 1) then begin
    alphastr= '!7a!X!Dw,fit!N = '+string(slope_e,format='(f7.3)')+' - '+ $
      string(ks_c68_e(0),format='(f7.3)')
    alphastr_1=' + '+string(ks_c68_e(1),format='(f7.3)')
    chisqstr='!7v!S!Dm!X!N!R!U2!N = '+string(rchisq_e,format='(f8.3)')
    alphatheorystr='!7a!X!Dx,theory!N ='+ $
      string(slope_theory,format='(f5.2)')+' !9+!X '+ $
      string(slope_theory_sigma,format='(f5.2)')
endif else begin
      alphastr= '!7a!X!Dw,fit!N is UNDEFINED'
      alphastr_1='FIT FAILS'
      chisqstr='!7v!S!Dm!X!N!R!U2!N is UNDEFINED'
endelse

alphatheorystr='!7a!X!Dx,theory!N ='+ $
  string(slope_theory,format='(f5.2)')+' !9+!X '+ $
  string(slope_theory_sigma,format='(f5.2)')

set_page,nh=1,nv=2

plot,kappa_data.f1,kappa_data.kappa, $
  xtitle='!7a!x!dw!n (Walen Slope)', $
  ytitle='!7v!dm!x!n!u2!n',/ylog, $  ;,yrange=yrange, $
  title=titstr ;  ,position=xpos2

xoutpoint=!x.crange(0) + 0.6*(!x.crange(1)-!x.crange(0))
xoutpoint1=!x.crange(0) + 0.75*(!x.crange(1)-!x.crange(0))
youtpoint1=10.^(!y.crange(0) + 0.9*(!y.crange(1)-!y.crange(0)))
youtpoint2=10.^(!y.crange(0) + 0.8*(!y.crange(1)-!y.crange(0)))
youtpoint3=10.^(!y.crange(0) + 0.7*(!y.crange(1)-!y.crange(0)))
youtpoint4=10.^(!y.crange(0) + 0.6*(!y.crange(1)-!y.crange(0)))

xyouts,xoutpoint,youtpoint1,alphastr
xyouts,xoutpoint1,youtpoint2,alphastr_1
xyouts,xoutpoint,youtpoint3,chisqstr
xyouts,xoutpoint,youtpoint4,alphatheorystr

if (status eq 1) then begin
    
    slope_minus=slope_e-ks_c68_e(0)
    slope_plus=slope_e+ks_c68_e(1)
    
    x_slope_arr=[slope_e,slope_e]
    y_slope_arr=10.^!y.crange
    x_slope_minus_arr=[slope_minus,slope_minus]
    x_slope_plus_arr=[slope_plus,slope_plus]
    
    oplot,x_slope_arr,y_slope_arr
    oplot,x_slope_minus_arr,y_slope_arr
    oplot,x_slope_plus_arr,y_slope_arr
    
endif

npts=n_elements(x_mean_e_kms)

dots,/fill

npts=n_elements(x_mean_e_kms)
npts_1d=npts/3
x_range=lin_bracket(x_mean_e_kms)
y_range=lin_bracket(y_mean_e_kms)
plot,[0],[0],xrange=x_range,yrange=y_range,ytitle='[U!De!N]!Dj!N, km/s', $
  xtitle='!7a!DR!N !9X!X [B/(m!Dp!N + m!De!N)/n!De!N]!Dj!N, km/s'
slope_theory_minus=slope_theory-slope_theory_sigma
slope_theory_plus=slope_theory+slope_theory_sigma

if (!x.crange(1) le !y.crange(1)) then begin
    fill_x_arr=!x.crange
    theory_line_x_arr=fill_x_arr
    theory_line_y_arr=fill_x_arr*slope_theory
    theory_line_y_minus_arr=fill_x_arr*slope_theory_minus
    theory_line_y_plus_arr=fill_x_arr*slope_theory_plus
    origin=[0.,0.]
    fill_point_1=[theory_line_x_arr(1),theory_line_y_minus_arr(1)]
    fill_point_2=[theory_line_x_arr(1),theory_line_y_plus_arr(1)]
    fill_point_3=[theory_line_x_arr(0),theory_line_y_minus_arr(0)]
    fill_point_4=[theory_line_x_arr(0),theory_line_y_plus_arr(0)]
    oplot,theory_line_x_arr,theory_line_y_minus_arr,linestyle=1
    oplot,theory_line_x_arr,theory_line_y_plus_arr,linestyle=1
endif else begin
    fill_y_arr=!y.crange
    theory_line_y_arr=fill_y_arr
    theory_line_x_arr=fill_y_arr/slope_theory
    theory_line_x_minus_arr=fill_y_arr/slope_theory_minus
    theory_line_x_plus_arr=fill_y_arr/slope_theory_plus
    origin=[0.,0.]
    fill_point_1=[theory_line_x_minus_arr(1),theory_line_y_arr(1)]
    fill_point_2=[theory_line_x_plus_arr(1),theory_line_y_arr(1)]
    fill_point_3=[theory_line_x_minus_arr(0),theory_line_y_arr(0)]
    fill_point_4=[theory_line_x_plus_arr(0),theory_line_y_arr(0)]
    oplot,theory_line_x_minus_arr,theory_line_y_arr,linestyle=1
    oplot,theory_line_x_plus_arr,theory_line_y_arr,linestyle=1
endelse
fill_array_1=[[origin],[fill_point_1],[fill_point_2]]
fill_array_2=[[origin],[fill_point_3],[fill_point_4]]
polycol=get_color_index('gray')
polyfill,fill_array_1,color=polycol,/data
polyfill,fill_array_2,color=polycol,/data

symbol_plot_y_1=!y.crange(0)+0.95*(!y.crange(1)-!y.crange(0))
symbol_plot_y_2=!y.crange(0)+0.90*(!y.crange(1)-!y.crange(0))
symbol_plot_y_3=!y.crange(0)+0.85*(!y.crange(1)-!y.crange(0))

symbol_plot_x=!x.crange(0)+0.05*(!x.crange(1)-!x.crange(0))
str_write_x=!x.crange(0)+0.08*(!x.crange(1)-!x.crange(0))
if (status eq 1 and slope_e lt 0.0) then begin
    symbol_plot_x=!x.crange(0)+0.85*(!x.crange(1)-!x.crange(0))
    str_write_x=!x.crange(0)+0.88*(!x.crange(1)-!x.crange(0))
endif 
dots,3,/fill
oplot,[symbol_plot_x],[symbol_plot_y_1],psym=8
dots,4,phase=45,/fill
oplot,[symbol_plot_x],[symbol_plot_y_2],psym=8
dots,4,/fill
oplot,[symbol_plot_x],[symbol_plot_y_3],psym=8

xyouts,str_write_x,symbol_plot_y_1,'X component'
xyouts,str_write_x,symbol_plot_y_2,'Y component'
xyouts,str_write_x,symbol_plot_y_3,'Z component'

dots,3,/fill
hyd_error_bars,x_mean_e_kms(0:npts_1d-1),y_mean_e_kms(0:npts_1d-1), $
  x_error_e_kms(0:npts_1d-1),y_error_e_kms(0:npts_1d-1),/overplot,psym=8
dots,4,phase=45,/fill
hyd_error_bars,x_mean_e_kms(npts_1d:2*npts_1d-1), $
  y_mean_e_kms(npts_1d:2*npts_1d-1),x_error_e_kms(npts_1d:2*npts_1d-1), $
  y_error_e_kms(npts_1d:2*npts_1d-1),/overplot,psym=8
dots,4,/fill
hyd_error_bars,x_mean_e_kms(2*npts_1d:3*npts_1d-1), $
  y_mean_e_kms(2*npts_1d:3*npts_1d-1),x_error_e_kms(2*npts_1d:3*npts_1d-1), $
  y_error_e_kms(2*npts_1d:3*npts_1d-1),/overplot,psym=8

if (status eq 1) then begin
    fit_line_x_arr=!x.crange
    fit_line_y_arr=!x.crange*slope_e
    fit_line_y_minus_arr=!x.crange*slope_minus
    fit_line_y_plus_arr=!x.crange*slope_plus
    
    oplot,!x.crange,fit_line_y_arr
    oplot,!x.crange,fit_line_y_minus_arr,linestyle=1
    oplot,!x.crange,fit_line_y_plus_arr,linestyle=1
    
endif

    

return
end







