PRO read_ib_mod, filename, index, energy, gains, errors, gain_other_box,$
             error_other_box,rchisq, day_label
;
;  Read version 5 interbox gains file.
;
;  Errors returned in index < 0
;     -1 = Not Version 5 file
;
   index = -1
   f = str_sep(filename,'/')
   f = f(n_elements(f)-1)
   version_whole = strmid(f,20,2)
   IF (version_whole LT '05') THEN return
   get_lun, u
   openr, u, filename
   line = ''
   days = ''
   ip = 0
   id = 0
   i = 0

   index = lonarr(64)
   energy = fltarr(64)
   gains = fltarr(64)
   errors = fltarr(64)
   gain_other_box = fltarr(64)
   error_other_box = fltarr(64)
   rchisq = fltarr(64)

   WHILE NOT eof(u) DO BEGIN
      readf, u, line
      IF (ip EQ 0) THEN BEGIN 
         CASE strmid(line,0,4) OF
            'Days': BEGIN
               days1 = str_sep(strcompress(line),':')
               days = str_sep(strtrim(days1(1),2),' ')
               id = 1
            END
            'Rela': BEGIN
               id = 2
            END 
            '----': IF (id EQ 3) THEN ip = 1 ELSE id = 3
            ELSE: BEGIN
               IF (id EQ 1) THEN BEGIN 
                  days = [days,str_sep(strtrim(strcompress(line),2),' ')]
               ENDIF
            END
         ENDCASE 
      ENDIF ELSE BEGIN
         fs = str_sep(strtrim(strcompress(line),2),' ')
         if n_elements(fs) gt 1 then begin
             index(i) = fs(0)
             energy(i) = fs(1)
             gains(i) = fs(2)
             errors(i) = fs(3)
             gain_other_box(i) = fs(4)
             error_other_box(i) = fs(5)
             rchisq(i) = fs(6)
             i = i+1
         endif
      ENDELSE 
   ENDWHILE 
   close, u
   free_lun, u

   index = index(0:i-1)
   energy = energy(0:i-1)
   gains = gains(0:i-1)
   errors = errors(0:i-1)
   rchisq = rchisq(0:i-1)

   day_label = strtrim(days(0),2)+' - '+strtrim(days(n_elements(days)-1),2)


   return
END


