pro read_intersweep, version, block_mode, is, verbose=verbose, tmp=tmp
;
;   Read Intersweep into structure is
;
;
;
;
is={ energy:fltarr(384,2), $
     nominal_energy:fltarr(384,2), $
     cal_energy_index:intarr(384,2),$
     cal_energy_sigma:fltarr(384,2)}

vw=string(long(version),format='(i2.2)')
vf=string(long((version-long(version)+0.0001)*1000),format='(i3.3)')

dir='/opt/hydra/gain_data/block_mode_'+string(block_mode,format='(i2.2)')+'/'
if keyword_set(tmp) then dir=dir+'tmp/'
;
;   Odd
;
filename1=dir+'po_os_'+vf+'_v'+$
  string(vw,format='(i2.2)')+'_'+string(block_mode,format='(i2.2)')+'.dat'
;
;   Even
;
filename2=dir+'po_es_'+vf+'_v'+$
  string(vw,format='(i2.2)')+'_'+string(block_mode,format='(i2.2)')+'.dat'

line=''
openr, 1, filename1
openr, 2, filename2
for i=0,2 do begin
    readf, 1, line
    readf, 2, line
endfor
all1=fltarr(6,384)
all2=fltarr(6,384)

readf, 1, all1
readf, 2, all2

is.energy(*,0)=all1(3,*)
is.energy(*,1)=all2(3,*)

is.nominal_energy(*,0)=all1(2,*)
is.nominal_energy(*,1)=all2(2,*)

is.cal_energy_sigma(*,0)=all1(4,*)
is.cal_energy_sigma(*,1)=all2(4,*)

is.cal_energy_index(*,0)=fix(all1(1,*)*1.001)
is.cal_energy_index(*,1)=fix(all2(1,*)*1.001)

close, 1
close, 2

end



