pro retrieve_data,date=date,start_time_ssm=start_time_ssm, $
                  end_time_ssm=end_time_ssm,species=species, $
                  moment_set=moment_set,time,density,den_frac_sig,u, $
                  u_sig,t,pprp_ele,pprl_ele,pprp_ion,pprl_ion, $
                  b_field,b_field_sig,num_valid,timetags=timetags_f, $
                  retrieve_status=retrieve_status

density=-1.e31
den_frac_sig=-1.e31
u=-1.e31
u_sig=-1.31
t=-1.e31
pprp_ele=-1.e31
pprl_ele=-1.e31
pprp_ion=-1.e31
pprl_ion=-1.e31
b_field=-1.e31
b_field_sig=-1.e31
num_valid=-1

start_time_str=time_ssm_2_str(start_time_ssm)
end_time_str=time_ssm_2_str(end_time_ssm)

time_ssm='time_bin_center_ssm'
bfield='bfield_54hz'

hyd_access,timetags_b,bfield,b_field, $
  get_timetags=[gen_time(date=date,time=start_time_str), $
                gen_time(date=date,time=end_time_str)]

if (size(timetags_b,/type) eq 0) then begin
    retrieve_status=-2
    print,'No initial timetags for B field'
    return
endif


if (species eq 'ele') then begin
    case moment_set of
        'two_swp': begin
            density_ele='sm_den'
            density_ion='m3_ion_n'
;;;Both of these quantities are now in km/s
            u_bulk='sm_total_u_avg_bulk'
            u_bulk_sig='sm_total_u_avg_bulk_var'
            temp_ele='sm_mean_nrg'
            temp_ion='m3_ion_temp'
            p_prl_ele='sm_prl_pres_cgs'
            p_prp_ele='sm_prp_pres_cgs'
            t_prl_ion='m3_ion_tparl'
            t_prp_ion='m3_ion_tperp'
            resolution='two_swp'
        end
        'm3': begin
            density_ele='m3_n'
            density_ion='m3_ion_n'
            u_bulk='m3_u'
            temp_ele='m3_temp'
            temp_ion='m3_ion_temp'
            t_prl_ele='m3_tparl'
            t_prp_ele='m3_tperp'    
            t_prl_ion='m3_ion_tparl'
            t_prp_ion='m3_ion_tperp'
            resolution='block'
        end
        else: stop,'No way:  moment set MUST be defined'
    endcase
endif else if (species eq 'ion') then begin  
    case moment_set of
        'two_swp': begin
            density_ele='sm_den'
            density_ion='m3_ion_n'
            u_bulk='m3_ion_u'
            u_bulk_sig='m3_ion_u'
            temp_ele='sm_mean_nrg'
            temp_ion='m3_ion_temp'
            p_prl_ele='sm_prl_pres_cgs'
            p_prp_ele='sm_prp_pres_cgs'
            t_prl_ion='m3_ion_tparl'
            t_prp_ion='m3_ion_tperp'
            resolution='block'
        end
        'm3': begin
            density_ele='m3_n'
            density_ion='m3_ion_n'
            u_bulk='m3_ion_u'
            u_bulk_sig='m3_ion_u'
            temp_ele='m3_temp'
            temp_ion='m3_ion_temp'
            t_prl_ele='m3_tparl'
            t_prp_ele='m3_tperp'
            t_prl_ion='m3_ion_tparl'
            t_prp_ion='m3_ion_tperp'
            resolution='block'
        end
        else: stop,'No way:  moment set MUST be defined'
    endcase
endif
;;;Get all quantities at specified resolution.

hyd_access,timetags,density_ele,dens_ele,get_timetags=[gen_time(date=date, $
                                                   time=start_time_str, $
                                                   /seconds), $
                                          gen_time(date=date, $
                                                   time=end_time_str, $
                                                   /seconds)]

if (size(timetags,/type) eq 0) then begin
    retrieve_status=-1
    print,'No initial timetags for density'
    return
endif

hyd_access,timetags_1swp,'hrkp_density', $
  hrkp_density,get_timetags=[gen_time(date=date, $
                                      time=start_time_str, $
                                      /seconds), $
                             gen_time(date=date, $
                                      time=end_time_str, $
                                      /seconds)]

if (size(timetags_1swp,/type) eq 0) then begin
    retrieve_status=-3
    print,'No initial timetags for HRKPs'
    return
endif

hyd_access,timetags,time_ssm,time
hyd_access,timetags,density_ion,dens_ion
hyd_access,timetags,u_bulk,u
hyd_access,timetags,temp_ele,t_ele
hyd_access,timetags,temp_ion,t_ion
hyd_access,timetags,t_prl_ion,tprl_ion
hyd_access,timetags,t_prp_ion,tprp_ion

b_field_out=hd_synchronize_bin_avg(timetags,timetags_b,b_field, $
                                       variance=b_field_sig,count=num_b)
b_field=b_field_out

hrkp_density_out=hd_synchronize_bin_avg(timetags,timetags_1swp, $
                                            hrkp_density, $
                                            variance=hrkp_den_sig, $
                                            count=num_d)

pprp_ion=hd_multiply(1.38e-16,hd_multiply(tprp_ion,dens_ion))
pprl_ion=hd_multiply(1.38e-16,hd_multiply(tprl_ion,dens_ion))

;;;Special cases for different species and moment sets.

if (species eq 'ele') then begin
    case moment_set of 
        'two_swp':begin
            hyd_access,timetags,p_prl_ele,pprl_ele
            hyd_access,timetags,p_prp_ele,pprp_ele
            hyd_access,timetags,u_bulk_sig,u_sig
            t_ele=hd_multiply(11.6e3,t_ele)
        end
        'm3':begin
            hyd_access,timetags,t_prl_ele,tprl_ele
            hyd_access,timetags,t_prp_ele,tprp_ele            
            u=hd_multiply(1.e-5,u)
            n_pts=n_elements(t_ele)
            u_sig=dblarr(n_pts,3)
            u_sig(*,0)=t_ele
            u_sig(*,1)=t_ele
            u_sig(*,2)=t_ele
;;;This formula gives u_sig in km/s
            u_sig=25.0*hd_sqrt(hd_divide(u_sig,2.0e5))
            pprp_ele=hd_multiply(1.38e-16,hd_multiply(tprp_ele,dens_ele))
            pprl_ele=hd_multiply(1.38e-16,hd_multiply(tprl_ele,dens_ele))
        end
        else: stop,'No way--moment set MUST be defined'
    endcase
endif else if (species eq 'ion') then begin
    u=hd_multiply(1.e-5,u)
    n_pts=n_elements(t_ele)
    u_sig=dblarr(n_pts,3)
    u_sig(*,0)=5.0
    u_sig(*,1)=5.0
    u_sig(*,2)=5.0
    case moment_set of 
        'two_swp':begin
            hyd_access,timetags,p_prl_ele,pprl_ele
            hyd_access,timetags,p_prp_ele,pprp_ele
        end
        'm3':begin
            hyd_access,timetags,t_prl_ele,tprl_ele
            hyd_access,timetags,t_prp_ele,tprp_ele            
            pprp_ele=hd_multiply(1.38e-16,hd_multiply(tprp_ele,dens_ele))
            pprl_ele=hd_multiply(1.38e-16,hd_multiply(tprl_ele,dens_ele))
        end
        else: stop,'No way--moment set MUST be defined'
    endcase    
endif

;;;Validity sieve

a_valid_0=where(timetags.valid_register ne 0,a_zero_count)
if (a_zero_count eq 0) then begin
  retrieve_status=-4
  print,'No valid points'
  return
endif
valid_time=fill_sieve(time,/positive,indices=time_indices)
valid_den_ele=fill_sieve(dens_ele,/positive,indices=den_ele_indices)
valid_den_ion=fill_sieve(dens_ion,/positive,indices=den_ion_indices)
valid_hrkp_den=fill_sieve(hrkp_den_sig,/positive,indices=hrkp_den_indices)
valid_u_0=fill_sieve(u(*,0),indices=u_0_indices)
valid_u_1=fill_sieve(u(*,1),indices=u_1_indices)
valid_u_2=fill_sieve(u(*,2),indices=u_2_indices)
valid_u_sig_0=fill_sieve(u_sig(*,0),/positive,indices=u_0_sig_indices)
valid_u_sig_1=fill_sieve(u_sig(*,1),/positive,indices=u_1_sig_indices)
valid_u_sig_2=fill_sieve(u_sig(*,2),/positive,indices=u_2_sig_indices)
valid_t_ele=fill_sieve(t_ele,/positive,indices=t_ele_indices)
valid_t_ion=fill_sieve(t_ion,/positive,indices=t_ion_indices)
valid_pprp_ele=fill_sieve(pprp_ele,/positive,indices=pprp_ele_indices)
valid_pprl_ele=fill_sieve(pprl_ele,/positive,indices=pprl_ele_indices)
valid_pprp_ion=fill_sieve(pprp_ion,/positive,indices=pprp_ion_indices)
valid_pprl_ion=fill_sieve(pprl_ion,/positive,indices=pprl_ion_indices)
valid_b_0=fill_sieve(b_field(*,0),indices=b_0_indices)
valid_b_1=fill_sieve(b_field(*,1),indices=b_1_indices)
valid_b_2=fill_sieve(b_field(*,2),indices=b_2_indices)
valid_b_sig_0=fill_sieve(b_field_sig(*,0),/positive,indices=b_0_sig_indices)
valid_b_sig_1=fill_sieve(b_field_sig(*,1),/positive,indices=b_1_sig_indices)
valid_b_sig_2=fill_sieve(b_field_sig(*,2),/positive,indices=b_2_sig_indices)
num_d_indices=where(num_d gt 1)

;;;Take intersection of all valid sets

a_valid_total=intersect(a_valid_0,time_indices)
a_valid_total=intersect(a_valid_total,den_ele_indices)
a_valid_total=intersect(a_valid_total,den_ion_indices)
a_valid_total=intersect(a_valid_total,hrkp_den_indices)
a_valid_total=intersect(a_valid_total,u_0_indices)
a_valid_total=intersect(a_valid_total,u_1_indices)
a_valid_total=intersect(a_valid_total,u_2_indices)
a_valid_total=intersect(a_valid_total,u_0_sig_indices)
a_valid_total=intersect(a_valid_total,u_1_sig_indices)
a_valid_total=intersect(a_valid_total,u_2_sig_indices)
a_valid_total=intersect(a_valid_total,t_ele_indices)
a_valid_total=intersect(a_valid_total,t_ion_indices)
a_valid_total=intersect(a_valid_total,pprp_ele_indices)
a_valid_total=intersect(a_valid_total,pprl_ele_indices)
a_valid_total=intersect(a_valid_total,pprp_ion_indices)
a_valid_total=intersect(a_valid_total,pprl_ion_indices)
a_valid_total=intersect(a_valid_total,b_0_indices)
a_valid_total=intersect(a_valid_total,b_1_indices)
a_valid_total=intersect(a_valid_total,b_2_indices)
a_valid_total=intersect(a_valid_total,b_0_sig_indices)
a_valid_total=intersect(a_valid_total,b_1_sig_indices)
a_valid_total=intersect(a_valid_total,b_2_sig_indices)
a_valid_total=intersect(a_valid_total,num_d_indices)

if (a_valid_total(0) eq -1) then begin
    print,'No valid points left in sieve'
    retrieve_status=-5
    return
endif
;;;Now select the valid data

time=time(a_valid_total)
dens_ele=dens_ele(a_valid_total)
dens_ion=dens_ion(a_valid_total)
hrkp_density=hrkp_density(a_valid_total)
u=u(a_valid_total,*)
u_sig=u_sig(a_valid_total,*)
t_ele=t_ele(a_valid_total)
t_ion=t_ion(a_valid_total)
pprp_ele=pprp_ele(a_valid_total)
pprl_ele=pprl_ele(a_valid_total)
pprp_ion=pprp_ion(a_valid_total)
pprl_ion=pprl_ion(a_valid_total)
b_field=b_field(a_valid_total,*)
b_field_sig=b_field_sig(a_valid_total,*)
timetags_f=timetags(a_valid_total)

num_b=num_b(a_valid_total)
num_d=num_d(a_valid_total)
hrkp_den_sig=hrkp_den_sig(a_valid_total)

;;;Get the time-based error on the electron density

hrkp_den_frac_sig=hrkp_den_sig/dens_ele/sqrt(float(num_d))
b_field_sig(*,0)=b_field_sig(*,0)/sqrt(float(num_b))
b_field_sig(*,1)=b_field_sig(*,1)/sqrt(float(num_b))
b_field_sig(*,2)=b_field_sig(*,2)/sqrt(float(num_b))
;print,b_field_sig(*,0)
;print,b_field_sig(*,1)
;print,b_field_sig(*,2)
;stop
if (species eq 'ion') then begin
    u=hd_multiply(1.e5,u)
    u_ion_mag=hd_magnitude(u)
    u=hd_multiply(1.e-5,u)
endif

error_algorithm,dens_ele,dens_ion,t_ele,t_ion, $
  ion_bulk_spd_cgs=u_ion_mag,ele_frac_err,sigma_n_ele,ion_frac_err, $
  sigma_n_ion,resolution=resolution

den_ele_frac_sig=sqrt(hrkp_den_frac_sig^2+ele_frac_err^2)

;print,hrkp_den_frac_sig
;print,u
;stop
;print,u_sig
;stop
;print,b_field
;stop
;print,b_field_sig
;stop
num_valid=n_elements(a_valid_total)

if (species eq 'ele') then begin
    t=t_ele
endif
if (species eq 'ion') then begin
    t=t_ion
endif
;;;; Electron density is to be used for either ions or electrons....
density=dens_ele
den_frac_sig=den_ele_frac_sig
retrieve_status=1
return
end
