function set_up_vertical_page,xmarg,ymarg,no_panels

;+
;  Arguments:  xmarg:  x margin array in normalized coordinates, e.g. [.1,.9]
;              ymarg:  y margin array in normalized coordinates,
;e.g. [.1,.9]
;              no_panels:  Number of panels in setup
;  Return value:  position array with 4 x no_panels elements
;-

position_arr=fltarr(4,no_panels)
position_arr(0,*)=xmarg(0)
position_arr(2,*)=xmarg(1)
position_arr(1,*)=ymarg(0)+ $
  indgen(no_panels)*(ymarg(1)-ymarg(0))/float(no_panels)
position_arr(3,*)=ymarg(0)+ $
  (indgen(no_panels)+1)*(ymarg(1)-ymarg(0))/float(no_panels)
return, position_arr
end
