FUNCTION tick_from_msm_to_hhmm, i, j, t
;+
; NAME:
;      TICK_FROM_MSM_TO_HHMM
;
; PURPOSE:
;      Generate a time string formatted HH:MM for use as an
;      axis label.
;
; CATEGORY:
;      Utility.
;
; CALLING SEQUENCE:
;      r=TICK_FROM_MSM_TO_HHMM(i,j,t)
;
;      plot, x, y, XTICKFORMAT='TICK_FROM_MSM_TO_HHMM'
; 
; INPUTS:
;      i, j: Unused
;      t: TIme in minutes.
;
; OPTIONAL INPUTS:
;      None.
;	
; KEYWORD PARAMETERS:
;      None.
;
; OUTPUTS:
;      String for tick label.
;
; OPTIONAL OUTPUTS:
;      None.
;
; COMMON BLOCKS:
;      None.
;
; SIDE EFFECTS:
;      None.
;
; RESTRICTIONS:
;      None.
;
; PROCEDURE:
;      Determine hours and minutes.  Small fractions are rounded up.
;
; EXAMPLE:
;      plot, x, y, tickformat='tick_from_msm_to_hhmm'
;
; MODIFICATION HISTORY:
;      $Log: tick_hhmm.pro,v $
;      Revision 1.1  2002/07/17 20:59:55  ddm
;      Initial revision
;
;      Revision 1.1  1998/11/17 21:36:47  rdh
;      Initial revision
;
;-

   th = long(0.1+t/60.0)
   tm = long(0.1+t - th*60.0)
;   ts1 = t - th*3600.0 - tm*60.0
;   ts = long(ts1)
;   tsf = long((ts1 - ts)*1000)

   time = string(th, format='(i2.2)')+':'+string(tm, format='(i2.2)')
;    string(ts, format='(i2.2)')+'.'+string(tsf,format='(i3.3)')
   
   return, time
END







