FUNCTION tick_hms_round, i, j, t,round=round
;+
; NAME:
;      TICK_HMS
;
; PURPOSE:
;      Generate a time string formatted HH:MM:SS.SSS for use as an
;      axis label.
;
; CATEGORY:
;      Utility.
;
; CALLING SEQUENCE:
;      r=TICK_HMS(i,j,t)
;
;      plot, x, y, XTICKFORMAT='TICK_HMS'
; 
; INPUTS:
;      i, j: Unused
;      t: TIme in seconds.
;
; OPTIONAL INPUTS:
;      None.
;	
; KEYWORD PARAMETERS:
;      None.
;
; OUTPUTS:
;      String for tick label.
;
; OPTIONAL OUTPUTS:
;      None.
;
; COMMON BLOCKS:
;      None.
;
; SIDE EFFECTS:
;      None.
;
; RESTRICTIONS:
;      None.
;
; PROCEDURE:
;      Determine Hours, minutes, seconds (up to 1 millisecond resolution.)
;
; EXAMPLE:
;      plot, x, y, tickformat='tick_hms'
;
; MODIFICATION HISTORY:
;      $Log: tick_hms_round.pro,v $
;      Revision 1.1  2002/10/25 17:06:07  ddm
;      Initial revision
;
;      Revision 1.1  1998/11/17 21:36:47  rdh
;      Initial revision
;
;-
round=1
th = long(t/3600.0)
tm = long((t - th*3600.0)/60.0)
ts1 = t - th*3600.0 - tm*60.0
ts = long(ts1)
tsf = long((ts1 - ts)*1000)
if (keyword_set(round)) then begin
    if (tsf ge 0.5) then ts=ts+1
    time = string(th, format='(i2.2)')+':'+ $
      string(tm, format='(i2.2)')+':'+ $
      string(ts, format='(i2.2)')    
endif else begin    
    time = string(th, format='(i2.2)')+':'+string(tm, format='(i2.2)')+':'+ $
      string(ts, format='(i2.2)')+'.'+string(tsf,format='(i3.3)')
endelse

return, time
END


