pro update_cal,cal_file,ib_update_vers,is_update_vers,block_mode

ib_update_vers=string(ib_update_vers,format='(f6.3)')
versions=str_sep(ib_update_vers,'.')
major_version=string(fix(versions(0)),format='(I2.2)')
minor_version=string(fix(versions(1)),format='(I3.3)')

cal_dir='/opt/hydra/gain_data/block_mode_10/'

fileroot='po_ib_'+minor_version+'_19960604_v'+major_version+'_10_sw'
fileext='.dat'
file1=cal_dir+fileroot+strtrim(1,2)+fileext
file2=cal_dir+fileroot+strtrim(2,2)+fileext
file3=cal_dir+fileroot+strtrim(3,2)+fileext
sweepfile=['  ',file1,file2,file3]

fid = cdf_open(cal_file)

varname1 = 'ELE_IGAIN_VERSION_010_e_03_03_i_03_03'
varname2 = 'IGAINS_010_e_03_03_i_03_03'
varname3 = 'IGAINS_SIGMA_010_e_03_03_i_03_03'
varname4 = 'CAL_ENERGY_VERSION'
varname5 = 'CAL_ENERGY_SEQ_BOX'
varname6 = 'CAL_ENERGY_INDEX'
varname7 = 'CAL_ENERGY_SEQ_BOX_SIGMA'

hyd_cdf_varget,fid,varname1,ib_gain_vers,rec_count=1
hyd_cdf_varget,fid,varname2,ib_gain_values,rec_count=1
hyd_cdf_varget,fid,varname3,ib_gain_errors,rec_count=1
hyd_cdf_varget,fid,varname4,cal_energy_vers,rec_count=1,rec_start=block_mode-1
hyd_cdf_varget,fid,varname5,cal_energy,rec_count=1,rec_start=block_mode-1
hyd_cdf_varget,fid,varname6,cal_energy_index,rec_count=1,rec_start=block_mode-1
hyd_cdf_varget,fid,varname7,cal_energy_sigma,rec_count=1,rec_start=block_mode-1

cal_energy_index0=cal_energy_index
read_intersweep,is_update_vers,block_mode,is,/verbose
cal_energy=is.energy
cal_energy_index=is.cal_energy_index
cal_energy_sigma=is.cal_energy_sigma
cal_energy_vers(*)=is_update_vers
ib_gain_vers=ib_update_vers

for i=1,3 do begin
    read_ib_mod,sweepfile(i),index,energy,gains,errors,gain_other_box,$
      error_other_box,rchisq,day_label

    swp_1x_start=(i-1)*64
    swp_2x_start=192+swp_1x_start
    swp_1x_end=swp_1x_start+31
    swp_2x_end=swp_2x_start+31

    ib_gain_values(swp_1x_start:swp_1x_end,0)=gains(0:31)
    ib_gain_errors(swp_1x_start:swp_1x_end,0)=errors(0:31)
    ib_gain_values(swp_1x_start:swp_1x_end,1)=gain_other_box(0:31)
    ib_gain_errors(swp_1x_start:swp_1x_end,1)=error_other_box(0:31)

    ib_gain_values(swp_2x_start:swp_2x_end,0)=gains(32:63)
    ib_gain_errors(swp_2x_start:swp_2x_end,0)=errors(32:63)
    ib_gain_values(swp_2x_start:swp_2x_end,1)=gain_other_box(32:63)
    ib_gain_errors(swp_2x_start:swp_2x_end,1)=error_other_box(32:63)
  
endfor
ib_gain_vers=float(ib_gain_vers)
hyd_cdf_varput,fid,varname1,ib_gain_vers
hyd_cdf_varput,fid,varname2,ib_gain_values
hyd_cdf_varput,fid,varname3,ib_gain_errors 
hyd_cdf_varput,fid,varname4,cal_energy_vers,rec_start=block_mode-1
hyd_cdf_varput,fid,varname5,cal_energy,rec_start=block_mode-1
hyd_cdf_varput,fid,varname6,cal_energy_index,rec_start=block_mode-1
hyd_cdf_varput,fid,varname7,cal_energy_sigma,rec_start=block_mode-1

cdf_close,fid

end





















