function ut_string,time_ssm,no_colon=no_colon

hour=fix(time_ssm/3600.d0)
minute=fix((time_ssm-3600.d0*hour)/60.d0)
second=fix(time_ssm-3600.d0*hour-60.d0*minute)

if (not keyword_set(no_colon)) then $
  out_str=string(hour,minute,second,format='(i2.2,":",i2.2,":",i2.2)') $
  else out_str=string(hour,minute,second, $
                      format='(i2.2,"h",i2.2,"m",i2.2,"s")')

return,out_str
end

