pro dot_plot, x, y, grid, xrange=xrange, yrange=yrange, $
              xlog=xlog, ylog=ylog,xstyle=xstyle, $
              nvert=nvert, $
              _extra=e
;+
; NAME:
;
;      dot_plot
;
; PURPOSE:
;
;      Replaces Scatter-Plot with a plot of dots sized by density in each
;      grid cell.
;
; CATEGORY:
;
;      Plot
;
; CALLING SEQUENCE:
;
;      dot_plot, x, y, grid, xrange=xrange, yrange=yrange, $
;              xlog=xlog, ylog=ylog,xstyle=xstyle, $
;              nvert=nvert, $
;              _extra=e
; 
; INPUTS:
;
;      x, y: Values
;      grid: [nx, ny] of output grid.
;
; OPTIONAL INPUTS:
;
;      None.
;	
; KEYWORD PARAMETERS:
;
;      xrange, yrange, xlog, ylog, xstyle: the usual plot keywords.
;      nvert: size of the dots.
;
; OUTPUTS:
;
;      None.
;
; OPTIONAL OUTPUTS:
;
;      None.
;
; COMMON BLOCKS:
;
;      None.
;
; SIDE EFFECTS:
;
;      Plot is generated.
;
; RESTRICTIONS:
;
;      None.
;
; PROCEDURE:
;
;      2D Histogram the data, create a dot-size based on histogram
;      value as fraction of the largest.
;
; EXAMPLE:
;
;      dot_plot, x, y, [20,20]
;
; MODIFICATION HISTORY:
;
;      Curator: rdh
;-
if keyword_set(xrange) then begin
    xmin=xrange(0)
    xmax=xrange(1)
endif else begin
    np=n_elements(x)
    xmin=min(x)
    if xmin lt 1.0 then xmin = min([xmin,0])
    xmax = (x(sort(x)))(0.99*np)*(1.01)
endelse
if keyword_set(yrange) then begin
    ymin=yrange(0)
    ymax=yrange(1)
endif else begin
    np=n_elements(x)
    ymin = min(y)
    if ymin lt 1.0 then ymin = min([ymin,0])
    ymax = (y(sort(y)))(0.99*np)*(1.01)
endelse

if n_params() eq 3 then begin
    nx=(grid(0))
    ny=(grid(1))
endif else begin
    nx=20
    ny=20
endelse


if keyword_set(xlog) then begin
    xmaxh=alog10(xmax)
    xminh=alog10(xmin > 1e-10)
    xh=alog10(x)
endif else begin
    xh=x
    xmaxh=xmax
    xminh=xmin
endelse
if keyword_set(ylog) then begin
    ymaxh=alog10(ymax)
    yminh=alog10(ymin > 1e-10)
    yh=alog10(y)
endif else begin
    yh=y
    ymaxh=ymax
    yminh=ymin
endelse

dx=(xmaxh-xminh)/float(nx)
dy=(ymaxh-yminh)/float(ny)

r=where(finite(xh) ne 0 and finite(yh) ne 0, nr)
if nr eq 0 then message, 'No finite-points sent'
hist=hist_2d(xh(r), yh(r), bin1=dx, bin2=dy, max1=xmaxh, max2=ymaxh, $
             min1=xminh, min2=yminh)

dims=size(hist, /dimensions)
nxh=dims(0)

hmax=max(hist)

dots, nvert, /fill
if !d.name eq 'X' then s0=0.2 else s0=0.1
    
xh=[0]
yh=[0]
plot, x, y, psym=8, symsize= 0.1,$
  title=title, $
  xtitle=xtitle, xrange=[xmin, xmax], xstyle=xstyle, xlog=xlog, $
  ytitle=ytitle, yrange=[ymin, ymax], ystyle=1, ylog=ylog, $
  _extra=e, /nodata

;for i=0,9 do begin
;    r=where(hist gt 0.1*i*hmax and hist le 0.1*(i+1)*hmax,nr)
;    if nr gt 0 then begin
;        yh=(r/(nxh) + 0.5)*dy+yminh
;        xh=((r mod (nxh)) + 0.5)*dx+xminh
;        if keyword_set(xlog) then xh=10.0^xh
;        if keyword_set(ylog) then yh=10.0^yh
;        oplot, xh, yh, psym=8, symsize=0.1*i+s0
;    endif
;endfor


r=where(hist gt 0 and hist le 0.01*hmax,nr)
if nr gt 0 then begin
    yh=(r/(nxh) + 0.5)*dy+yminh
    xh=((r mod (nxh)) + 0.5)*dx+xminh
    if keyword_set(xlog) then xh=10.0^xh
    if keyword_set(ylog) then yh=10.0^yh
    oplot, xh, yh, psym=8, symsize=0.01+s0
endif
for i=0,99 do begin
    r=where(hist gt 0.01*i*hmax and hist le 0.01*(i+1)*hmax,nr)
    if nr gt 0 then begin
        yh=(r/(nxh) + 0.5)*dy+yminh
        xh=((r mod (nxh)) + 0.5)*dx+xminh
        if keyword_set(xlog) then xh=10.0^xh
        if keyword_set(ylog) then yh=10.0^yh
        oplot, xh, yh, psym=8, symsize=0.01*i+s0
    endif
endfor

end
