pro dots, nvert, fill=fill, symsize=symsize, phase=phase
;+
; NAME: dots
; PURPOSE: sets the user symbol (psym=8) to a circle.
; CATEGORY: plotting
; CALLING SEQUENCE: dots, [nvert], /fill
; OPTIONAL INPUTS:   
;     <nvert> number of vertices in each dot.  Default
;     is 16.  The more vertices, the slower the printing.
; KEYWORD PARAMETERS:
;     /fill  fill in the dots, default is empty circle.
;     phase=<degrees> from 0 at start
; SIDE EFFECTS: Sets user symbol.
; EXAMPLE:
;     dots, 36, /fill
;     plot, findgen(5), psym=8, symsize=1.5
; MODIFICATION HISTORY: written, jbf, April 23, 1999.
;-
  if n_elements( nvert ) eq 0 then nvert=16
  if n_elements( symsize ) eq 0 then symsize=1.0
  if symsize eq 0.0 then symsize=1.0
  if not keyword_set(phase) then phase=0.0
  a= findgen(nvert+1)/nvert * 2 * !pi+ phase*!dtor
  usersym, cos(a)*symsize, sin(a)*symsize, fill=keyword_set(fill)
end


