function fancy_date, date=date_in, full=full
;+
;   Return the fancy month string:
;   /full uses the full month name, otherwise 3 characters are used.
;
;
;   print, fancy_date(date=19960529)
;   
;   'May 29, 1996'
;
;-
if not keyword_set(date_in) then message, 'Keyword date required'

months=['January', 'February', 'March', 'April', 'May', 'June', $
        'July', 'August', 'September', 'October', 'November', 'December']

date=strtrim(date_in,2)
year=strmid(date,0,4)
month=months[long(strmid(date,4,2))-1]
if not keyword_set(full) then month=strmid(month,0,3)
day=strtrim(long(strmid(date,6,2)),2)

fancy_date=month+' '+day+', '+year

return, fancy_date
end
