function filter_points, x, y, sigx, sigy, cmin=cmin, cmax=cmax
;+
;
;   Filter counts too low or too high, NaNs.
;
;-
rr= where( x gt cmin and y gt cmin and x lt cmax and y lt cmax, nrr)
                                ; 'filters this is corrected counts...'

if nrr eq 0 then return, -1

rr_filter = where(finite(   x(rr)) NE 0 AND $
                  finite(   y(rr)) NE 0 AND $
                  finite(sigx(rr)) NE 0 AND $
                  finite(sigy(rr)) NE 0)

IF n_elements(rr) NE n_elements(rr_filter) THEN BEGIN

    rr_nan = where(finite(   x(rr)) EQ 0 OR finite(   y(rr)) EQ 0 OR $
                   finite(sigx(rr)) EQ 0 OR finite(sigy(rr)) EQ 0)

    print, 'WARNING - NaNs incountered.'
    print, 'x(rr): ', (x(rr))(rr_nan)
    print, 'sigx(rr): ', (sigx(rr))(rr_nan)
    print, 'y(rr): ', (y(rr))(rr_nan)
    print, 'sigy(rr): ', (sigy(rr))(rr_nan)

    rr = rr(rr_filter)

ENDIF 

x=x(rr)
y=y(rr)
sigx=sigx(rr)
sigy=sigy(rr)

return, 0
end


