
pro fit_ibfunction, ratio, frequency, peak_ratio, error_peak,status,$
             b_fit, sigma_b_fit

; purpose to develope fitting routine to 
;;;;;;   frequency = a * R^m*exp(c*R^2)
;;;;;;   where R is the ratio between detectors
;;;;;;   and frequency is its occurrent
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;   desire to estimate peak of teh noisy curve by differentiation
;;;;;;;        of model
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
status=-1.0e31
peak_ratio=-1.0e31
error_peak=-1.0e31
b_fit=dblarr(3)-1.0e31
;print, b_fit
sigma_b_fit=dblarr(3)-1.0e31
igood=where(ratio gt 0 and frequency gt 0)
x=ratio(igood)*1.0d0
y=frequency(igood)*1.0d0

f_0=x*0+1
f_1=alog(x)
f_2=x^2
g=alog(y)
sigma_g=1.0d0/y^0.5
sigma_b=1
inv_accuracy=1
generalized_least_squares_fit,g, sigma_g, 3, f_0, f_1, f_2, $
      b=b, sigma_b=sigma_b, rchi2=rchi2, $
    istat=istat, inv_accuracy=inv_accuracy
if keyword_set(verbose) then begin
    print, 'b:', b
    print, 'sigma_b:', sigma_b
    print, 'rchi2=', rchi2
    print, 'istat=', istat
    print, 'inv_accuracy=', inv_accuracy
    sigma_b_fit=sigma_b
    print,'b_fit=', b
endif
b_fit=b
stop

status=istat

peak_ratio_sq=-b(1)/2/b(2)
if(peak_ratio_sq ge 0) then begin
   peak_ratio=(peak_ratio_sq)^0.5
   error_peak= 0.5/peak_ratio*$
        (sigma_b(1)^2/4/b(2)^2 + b(1)^2/4/b(2)^4*sigma_b(2)^2)^0.5
endif else begin
    print, 'Peak Ratio Sq=', peak_ratio_sq
    status=-999
endelse

end

pro test_fit_ibfunction

ratio=findgen(1000)/999.*5.0d0
frequency0= 100.0d0*ratio^1.743*exp(-(ratio/2.179)^2)
frequency= abs(frequency0 + frequency0^0.5*sin(100*ratio))
bin=dblarr(3)
bin(0)=alog(100)
bin(1)=1.743
bin(2)=-1./(2.179)^2
plot, ratio, frequency, xtitle='!17ratio', ytitle='!17Frequency'



fit_ibfunction, ratio,frequency, peak_ratio, error_peak,status,$
             b, sigma_b

print, bin(0), b(0), sigma_b(0)/b(0)
print, bin(1), b(1), sigma_b(1)/b(1)
print, bin(2), b(2), sigma_b(2)/b(2)
print, 'peak_in=', (-bin(1)/2./bin(2))^0.5
print, 'peak_ratio_out=', peak_ratio, error_peak

oplot, peak_ratio*[1,1],[0,10000],linestyle=5

frequ= exp(b(0)+b(1)*alog(ratio)+b(2)*ratio^2)
oplot, ratio, frequ


end
