function fit_peak_gaussian, x, y, peak, error_peak, plot=plot
;
;
;   Fit the peak of the distribution to a gaussian
;
ymax=max(y,iymax)
r=where(y gt ymax*0.2,nr)

f_0=replicate(1.0, nr)
f_1=x(r)
f_2=f_1^2
g_data=alog(y(r))
sigma_g=1.0/sqrt(y(r))
sigma_b=1
inv_accuracy=1
generalized_least_squares_fit, g_data, sigma_g,3,f_0,f_1,f_2, b=b, $
  sigma_b=sigma_b, rchi2=rchis2,istat=istat,inv_accuracy=inv_accuracy
peak=-b(1)/2./b(2)
unpeak= ( (sigma_b(1)/2./b(2))^2 + (b(1)/2/b(2)^2*sigma_b(2))^2)^0.5
width=1.0/sqrt(-b(2))
amplitude=exp(b(0)+(peak/width)^2)
          
error_peak=unpeak
if keyword_set(plot) then begin
    gaus=amplitude*exp(-((x-peak)/width)^2)
    oplot, x, gaus, linestyle=1

    oplot, [1,1]*peak, [0,1000], linestyle=1
    oplot, [1,1]*peak-unpeak, [0,1000], linestyle=1
    oplot, [1,1]*peak-unpeak, [0,1000], linestyle=1

    xyouts, -10,0.3*!y.crange(1)+0.7*!y.crange(0), $
      'PEAK='+string(peak,format='(f7.4)')
    xyouts, -10,0.2*!y.crange(1)+0.8*!y.crange(0), $
      'ERR  ='+string(error_peak,format='(f7.4)')

endif
return, 0
end
