pro fit_to_ratio, x, y, peak, error_peak, plot=plot, title=title, $
                  log=log
;
;   Fit the histogram ratio distribution to a function and determine 
;   the peak and width
;
;   /log means the x=log(ratio), y=freq.
;
;
if not keyword_set(plot) then plot=0
if not keyword_set(title) then title='Ratio Histogram Distribution'
if keyword_set(plot) then begin
    xtitle='SLOPE (RATIO BOX 2/BOX 1)'
    if keyword_set(log) then xtitle='Ln '+xtitle
    plot, x, y, psym=10, chars=1.5, $
      title=title, xtitle=xtitle, $
      ytitle='Frequency'
endif

if keyword_set(log) then begin
    status=fit_peak_gaussian(x, y, peak, error_peak, plot=plot)
    peak=exp(peak)
    error_peak=error_peak*peak
endif else begin
;    fit_ibfunction, x(2:*), y(2:*), peak, error_peak, status, $
;    b_fit, sigma_b_fit
    peak=0.20
    error_peak=0.10
endelse
if keyword_set(plot) then begin
    xyouts, -10,0.8*!y.crange(1)+0.2*!y.crange(0), $
      'IBTRIM='+string(peak,format='(f7.4)')
    xyouts, -10,0.7*!y.crange(1)+0.3*!y.crange(0), $
      'ERR  ='+string(error_peak,format='(f7.4)')
endif
;stop
end
