function hd_mjf_offset, timetags, filter=filter
;+
;  Return the Offset from Major Frame for Hydra Quantity Time.
;  Defined for Hydra 54 Hz B-data.
;
;  Input: 
;        hyd_access timetags
;
;  Keyword Inout:
;        filter=#                Offset < n     -> 0
;                                Offset >= n    -> 1
;
;-
   hyd_access, timetags, 'time_bin_center_ssm', time
   indexes=make_array(n_elements(timetags), /int, value=-1)
;
;  Determine Date
;
   doy96=long(timetags.bin_start)
   doy96=doy96(uniq(doy96, sort(doy96)))
;
;  Read MJF_TIME_SSM from ddcal file.
;
   for i=0, n_elements(doy96)-1 do begin
       dissect_doy96, doy96(i), year, month, day, $
         hour, minute, second, msec
       date=long(year)*10000+long(month)*100+long(day)
;
;  Read MJF_TIME_SSM from ddcal file.
;
       file=hydra_findfile(date, /ddcal, version=v)
       id=cdf_open(file)
       nrecs=7000
       cdf_varget, id, rec_start=srec, rec_count=nrecs, 'MJF_TIME_SSM', $
         mjf_time
       cdf_close, id
       mjf_time=mjf_time(where(mjf_time ne 0))
       hd_make_timetags, mjf_timetags, mjf_time, 9.2, /ssm, dateyyyymmdd=date
       hd_insert_fill, mjf_timetags, mjf_time
       r=where(mjf_time lt -1e30,nr)
       if nr gt 0 then begin
           mjf_time(r)=mjf_time(r-1)
       endif
       r=where(long(timetags.bin_start) eq doy96(i), nr)
       if nr gt 0 then begin
;
;  Calculate index offset
;
           daily_timetags=timetags(r)
           mjf_time_day= $
             hd_synchronize_nearest_neighbor(daily_timetags, $
                                             mjf_timetags, mjf_time)
           ind=(time(r)-mjf_time_day)/9.2d0 mod 1.0
           rr=where(ind lt 0,nrr)
           if nrr gt 0 then ind(rr)=1+ind(rr)
           indexes(r)=(ind*512) mod 512

       endif
   endfor

   if keyword_set(filter) then begin
       indexes_filtered=make_array(size=size(indexes), val=1)
       r=where(indexes lt filter,nr)
       if nr gt 0 then indexes_filtered(r)=0
       return, indexes_filtered
   endif else begin
       return, indexes
   endelse
end
