function hd_rotz, alpha, vector
;+
; NAME: hd_rotz
;
; PURPOSE: rotate vectors around the z axis.
;
; CATEGORY: 
;
; CALLING SEQUENCE: newv= hd_rotz( alpha, oldv )
; 
; INPUTS: alpha, radians.
;         oldv, hyd access vector (*,3)
;
; OUTPUTS: newv, hyd access vector (*,3)
;
; RESTRICTIONS:
;    fill value is -1e31
;
; PROCEDURE:
;
; EXAMPLE:
;
; MODIFICATION HISTORY:
;    written, July 23, 2001, jbf  U of I
;-

  
  result= make_array( size= size(vector), value=hd_get_fill() )
  
  r= where( alpha gt -1e30 and $
            vector(*,0) gt -1e30 and $
            vector(*,1) gt -1e30 )
  if r(0) ne -1 then begin
      result(r,0)= cos(alpha(r))*vector((r),0)  -  sin(alpha(r))*vector((r),1)
      result(r,1)= sin(alpha(r))*vector((r),0)  +  cos(alpha(r))*vector((r),1)
  endif
  result(*,2)= vector(*,2)
  
  return, result

end
